ORCA/M Asm65816 2.1.0

0001 8E9E                       EJECT 
0002 8E9E                       TITLE 'Text Page 2 Desk Accessory'
0003 8E9E
0004 8E9E              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0005 8E9E              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 5:22:20 PM
0006 8E9E
0007 8E9E              ******************************************************
0008 8E9E              *                                                    *
0009 8E9E              *             Text Page 2 Desk Accessory             *
0010 8E9E              *                                                    *
0011 8E9E              *                    by                              *
0012 8E9E              *               Fern Bachman     1985-1987           *
0013 8E9E              *               Joe Bo           1987-1989           *
0014 8E9E              *                                                    *
0015 8E9E              *       Copyright Apple Computer, Inc. 1985-1989     *
0016 8E9E              *                All Rights Reserved.                *
0017 8E9E              *                                                    *
0018 8E9E              ******************************************************
0019 8E9E
0020 8E9E
0021 8E9E                                                      ; SEG $FF
0022 8E9E              TEXTPG2DA EQU   *
0023 8E9E                                                      ; SEG $00
0024 8E9E AD 15 C0              LDA   RDCXROM                  ;Save/restore INTCXROM/SLOTCXROM
0025 8EA1 48                    PHA                            ;
0026 8EA2 AD 36 C0              LDA   CYAREG                   ;Save system speed
0027 8EA5 48                    PHA                            ;Save it
0028 8EA6 20 EE A9              JSR   HOMEFF                   ;Clear screen
0029 8EA9 20 11 9A              JSR   TURNONMTXT               ;Enable mouse text character printing
0030 8EAC
0031 8EAC A2 01                 LDX   #CPHPOSITION             ;Horizontal position of message
0032 8EAE A0 01                 LDY   #CPVPOSITION             ;Vertical position of message
0033 8EB0 A9 EE                 LDA   #ALTDSPMODE              ;Message number
0034 8EB2 20 D1 93              JSR   PRINTMSGXY               ;Show it
0035 8EB5 20 40 96              JSR   UNDERTITLE               ;Underline title
0036 8EB8
0037 8EB8 A2 01                 LDX   #CPHPOSITION             ;Horizontal position for message
0038 8EBA A0 0B                 LDY   #CPVPOSITION+10          ;Vertical position for message
0039 8EBC A9 ED                 LDA   #TURN                    ;Message number
0040 8EBE 20 D1 93              JSR   PRINTMSGXY               ;Print 'Turn'
0041 8EC1
0042 8EC1 A9 EE                 LDA   #ALTDSPMODE              ;Message number
0043 8EC3 20 80 C0              JSR   PRINTMSG
0044 8EC6 AF 7C 01 E1           LDA   >TP2MODE                 ;<>= then already active
0045 8ECA D0 04                 BNE   @1                       ;
0046 8ECC A9 EF                 LDA   #ON                      ;Give 'On' message if here
0047 8ECE 80 02                 BRA   @2                       ;
0048 8ED0              @1       EQU   *
0049 8ED0 A9 F0                 LDA   #OFF                     ;'Off' message number
0050 8ED2              @2       EQU   *
0051 8ED2 20 80 C0              JSR   PRINTMSG
0052 8ED5
0053 8ED5 A2 01                 LDX   #CPHPOSITION             ;Horizontal footnote position
0054 8ED7 A0 16                 LDY   #FNPOSITION              ;Vertical footnote position
0055 8ED9 A9 14                 LDA   #CANCELESC               ;Message
0056 8EDB 20 D1 93              JSR   PRINTMSGXY               ;Print it
0057 8EDE
0058 8EDE A9 F1                 LDA   #ACCEPT                  ;Message
0059 8EE0 20 80 C0              JSR   PRINTMSG
0060 8EE3
0061 8EE3 20 2E 96              JSR   ALLBORDER                ;Put up complete border
0062 8EE6
0063 8EE6              @5       EQU   *
0064 8EE6 20 74 CF              JSR   XRDKBD                   ;Read keyboard
0065 8EE9 10 FB                 BPL   @5                       ;Loop til key pressed
0066 8EEB C9 8D                 CMP   #RETURNKEY               ;Return then do it
0067 8EED F0 09                 BEQ   @3                       ;
0068 8EEF C9 9B                 CMP   #ESCKEY                  ;Escape key then do nothing
0069 8EF1 F0 08                 BEQ   @4                       ;
0070 8EF3 20 51 9A              JSR   NEWBELL1                 ;Unknown key then beep and loop
0071 8EF6 80 EE                 BRA   @5                       ;
0072 8EF8
0073 8EF8              @3       EQU   *
0074 8EF8 20 02 8F              JSR   TEXT2COPYFF              ;Toggle it
0075 8EFB
0076 8EFB              @4       EQU   *
0077 8EFB 68                    PLA                            ;Restore system speed
0078 8EFC 8D 36 C0              STA   CYAREG                   ;Set it back
0079 8EFF 4C E5 90              JMP   RDYSBMENU0               ;Exit via control panel routine
0080 8F02
0081 8F02
0082 8F02              *
0083 8F02              * This routine installs a heartbeat task
0084 8F02              * that copies text page 2 to bank E0 for
0085 8F02              * the Mega // to display on every VBL.
0086 8F02              *
0087 8F02              * This is a toggle (enable/disable) routine.
0088 8F02              * If auto text copy is on, on entry, it is disabled on exit.
0089 8F02              * If auto text copy is off, on entry, it is enabled on exit.
0090 8F02              *
0091 8F02              * For Gyro, no heart beat task is required.
0092 8F02              * Toggle hardware bit5 of shadow register, $c035 
0093 8F02              * is equivalent to software copying.
0094 8F02              *
0095 8F02              * This routine can be invoked from Classic Desk Accessory
0096 8F02              * or mainside entry point $f962. In the case of CDA, an      
0097 8F02              * interrupt occurred and the enviroments are stored and restored
0098 8F02              * during in and out of the CDA, this includes store and restore of
0099 8F02              * SHADOW reg, therefore it is necessay to update IRQ_SHADOW to   
0100 8F02              * reflect the most current states of shadowing.  When exits, then
0101 8F02              * restoring of SHADOW reg from IRQ_SHADOW would show the users'
0102 8F02              * preference states.
0103 8F02
0104 8F02              TEXT2COPYFF EQU   *                     ;Entry from $f962 also !!!   
0105 8F02 8B                    PHB                            ;Save data bank
0106 8F03 20 82 F8              JSR   DBTOE1                   ;Change to $e1
0107 8F06 AD 7C 01              LDA   |TP2MODE                 ;Toggle the flag
0108 8F09 49 FF                 EOR   #$FF                     ;
0109 8F0B 8D 7C 01              STA   |TP2MODE                 ;Save back, 0/1 = off/on
0110 8F0E 20 2E 7A              JSR   SETTEXT2REG              ;
0111 8F11 90 02                 BCC   @1                       ;BRA for //gs
0112 8F13 AB                    PLB                            ;Restore data bank
0113 8F14 60                    RTS                            ;
0114 8F15
0115 8F15
0116 8F15              @1       EQU   *                        ;//gs uses software copy !!!
0117 8F15 AB                    PLB                            ;Restore its data bank
0118 8F16 E2 40                 SEP   #$40                     ;Set 'v' to indicate enabling routine
0119 8F18 18                    CLC                            ;Make call in full native mode
0120 8F19 FB                    XCE                            ;
0121 8F1A 08                    PHP                            ;Preserve entry status
0122 8F1B C2 30                 REP   #$30                     ;16 bit land required
0123 8F1D 50                    OPCODE BVC                     ;Do a trick to save a byte
0124 8F1E              @2       EQU   *
0125 8F1E B8                    CLV                            ;Skipped first time through this code
0126 8F1F F4 E1 00              PEA   TP2THDR>>16              ;High word of routine address
0127 8F22 F4 70 01              PEA   |TP2THDR                 ;Low word of routine address
0128 8F25                       LONGI ON
0129 8F25 A2 03 12              LDX   #SETHEART                ;Set up heartbeat task
0130 8F28 70 03                 BVS   @14                      ;'v'=1 then put in heartbeat queue
0131 8F2A A2 03 13              LDX   #DELHEART                ;Remove from heartbeat task
0132 8F2D                       LONGI OFF
0133 8F2D              @14      EQU   *                        ;'v'=0=disable 'v'=1=enable routine
0134 8F2D 22 00 00 E1           JSL   >DISPATCH1               ;Off to tool locator
0135 8F31 B0 EB                 BCS   @2                       ;Already on then disable txt pg 2 copier
0136 8F33 28                    PLP                            ;Recall entry status (8 bit mode)  
0137 8F34 A9 08                 LDA   #$08                     ;Enable VBL's to start up copier
0138 8F36 0C 41 C0              TSB   INTEN                    ;
0139 8F39 FB                    XCE                            ;Switch back to entry state now
0140 8F3A 60                    RTS                            ;Back to caller
0141 8F3B
0142 8F3B
0143 8F3B
0144 8F3B                       TITLE 'Special Entry Routines'
0145 8F3B
0146 8F3B              ******************************************************
0147 8F3B              *                                                    *
0148 8F3B              *   Special Entry Rtnes for Control Panel Desk Acc   *
0149 8F3B              *                                                    *
0150 8F3B              *                    by                              *
0151 8F3B              *               Fern Bachman     1985-1987           *
0152 8F3B              *               Joe Bo           1987-1989           *
0153 8F3B              *                                                    *
0154 8F3B              *       Copyright Apple Computer, Inc. 1985-1989     *
0155 8F3B              *                All Rights Reserved.                *
0156 8F3B              *                                                    *
0157 8F3B              ******************************************************
0158 8F3B
0159 8F3B
0160 8F3B                                                      ; SEG $FF
0161 8F3B              SPEC_PANEL EQU   *                      ;Closed Apple reset enters here
0162 8F3B                                                      ; SEG $00
0163 8F3B 78                    SEI                            ;Disallow data register interrupts
0164 8F3C A9 10                 LDA   #$10                     ;Bit 4 is data register interrupt enable
0165 8F3E 1C 27 C0              TRB   KMSTATUS                 ;
0166 8F41 58                    CLI                            ;Re-enable interrupts
0167 8F42 20 2C FA              JSR   T480CARD2                ;'z'=0 if 80 cols - 'z'=1 if 40 cols OK
0168 8F45 F0 03                 BEQ   @1                       ;= then 80 columns OK
0169 8F47 8D 0A C0              STA   SETINTC3ROM              ;Enable internal $C300 ROM
0170 8F4A              @1       EQU   *
0171 8F4A A9 11                 LDA   #$11                     ;Must set up funny 40 column mode
0172 8F4C 20 E9 A9              JSR   C300FF                   ; this way.
0173 8F4F 20 11 9A              JSR   TURNONMTXT               ;Enable mouse text characters
0174 8F52 A9 80                 LDA   #$80                     ;Must run in high speed
0175 8F54 8D 36 C0              STA   CYAREG                   ;Ignore disk ][ motor on detects
0176 8F57 8F 38 01 E1           STA   >SYSTEMSPD               ;Besure all runs fast
0177 8F5B 0A                    ASL   A                        ;Zero out bytes to force reboot
0178 8F5C 9C F3 03              STZ   SOFTEV+1                 ;Be sure vectors cause cold boot
0179 8F5F 9C F4 03              STZ   PWREDUP                  ;Reset power up byte too.
0180 8F62 A0 08                 LDY   #SPECOPV                 ;Vertical pstn to start on
0181 8F64 A2 00                 LDX   #SPECOPH                 ;Horizontal pstn to start on
0182 8F66 A9 0D                 LDA   #SPCHOICES               ;Show choices
0183 8F68 20 D1 93              JSR   PRINTMSGXY               ; to user here
0184 8F6B 20 2E 96              JSR   ALLBORDER                ;Put up complete border
0185 8F6E 8D 06 C0              STA   SETSLOTCXROM             ;Enable external CX ROM as per entry state
0186 8F71              @2       EQU   *
0187 8F71 AD 00 C0              LDA   KBD                      ;Check for what to do
0188 8F74 10 FB                 BPL   @2                       ;Loop til key pressed
0189 8F76 8D 10 C0              STA   KBDSTRB                  ;Clear key pressed
0190 8F79 C9 B1                 CMP   #'1'                     ;1,2,3,4 only keys allowed
0191 8F7B F0 24                 BEQ   @6                       ;Enter Control Panel
0192 8F7D C9 B2                 CMP   #'2'                     ;= 2 then do #2
0193 8F7F F0 0D                 BEQ   @3                       ;Restore standards and 60 hertz
0194 8F81 C9 B3                 CMP   #'3'                     ;= 3 then do #3
0195 8F83 F0 0D                 BEQ   @4                       ;Restore standards and 50 hertz
0196 8F85 C9 B4                 CMP   #'4'                     ;=4 then do #4
0197 8F87 F0 17                 BEQ   @5                       ;Continue with boot
0198 8F89 20 51 9A              JSR   NEWBELL1                 ;Indicate illegal choice
0199 8F8C 80 E3                 BRA   @2                       ;Loop for new keypress
0200 8F8E
0201 8F8E
0202 8F8E              @3       EQU   *
0203 8F8E 5C 25 B9 FF           JMP   >WRITESTD                ;Write standards with 60 hertz
0204 8F92
0205 8F92              @4       EQU   *
0206 8F92 22 25 B9 FF           JSL   >WRITESTD                ;Write standards with 60 hertz
0207 8F96 A9 01                 LDA   #DISPOP4_0+1-DISPOP4_0   ;50 hertz indicator
0208 8F98 8F DD 02 E1           STA   >USERHERTZ               ;Make change
0209 8F9C 5C 4E B9 FF           JMP   >WRITEBR                 ;Write change to BATTERYRAM
0210 8FA0
0211 8FA0              @5       EQU   *
0212 8FA0 6B                    RTL                            ;Back to caller
0213 8FA1
0214 8FA1
0215 8FA1              @6       EQU   *                        ;Set screen size before entry
0216 8FA1 AF D9 02 E1           LDA   >USERCOL                 ;0=40 / 1=80
0217 8FA5 F0 05                 BEQ   CTRL_PANEL               ;= then leave in 40 columns 
0218 8FA7 A9 1B                 LDA   #MTXTON                  ;Enable Mouse Text and 80 columns
0219 8FA9 20 E9 A9              JSR   C300FF                   ;Enable 80 columns
0220 8FAC
0221 8FAC
0222 8FAC              * Fall into control panel from here
0223 8FAC
0224 8FAC
0225 8FAC
0226 8FAC
0227 8FAC                       TITLE 'Control Panel Main Routines'
0228 8FAC
0229 8FAC              ******************************************************
0230 8FAC              *                                                    *
0231 8FAC              *   Main Routines for Control Panel Desk Accessory   *
0232 8FAC              *                                                    *
0233 8FAC              *                    by                              *
0234 8FAC              *               Fern Bachman     1985-1987           *
0235 8FAC              *               Joe Bo           1987-1989           *
0236 8FAC              *                                                    *
0237 8FAC              *       Copyright Apple Computer, Inc. 1985-1989     *
0238 8FAC              *                All Rights Reserved.                *
0239 8FAC              *                                                    *
0240 8FAC              ******************************************************
0241 8FAC
0242 8FAC
0243 8FAC                                                      ; SEG $FF
0244 8FAC              CTRL_PANEL EQU   *                      ;E1 vector enters here
0245 8FAC                                                      ; SEG $00
0246 8FAC AD 15 C0              LDA   RDCXROM                  ;Save/restore INTCXROM/SLOTCXROM status
0247 8FAF 48                    PHA                            ;
0248 8FB0 08                    PHP                            ;Disable int while saving/changing vector
0249 8FB1 78                    SEI                            ;
0250 8FB2 AD 27 C0              LDA   KMSTATUS                 ;Save keyboard interrupt enable
0251 8FB5 85 B0                 STA   ZKMSTATUS                ;
0252 8FB7 AD 23 C0              LDA   VGCINT                   ;Bit 2 hold 1-sec int enable bit
0253 8FBA 85 B1                 STA   ZVGCINT                  ;Save for later
0254 8FBC A9 04                 LDA   #$04                     ;Bit 2 is kbd interrupt enable bit
0255 8FBE 1C 27 C0              TRB   KMSTATUS                 ;Disable keyboard interrupts
0256 8FC1 0C 23 C0              TSB   VGCINT                   ;Enable 1 second interrupt
0257 8FC4 9C 32 C0              STZ   SCANINT                  ;Reset 1 second timer interrupt
0258 8FC7
0259 8FC7 C2 20                 REP   #$20                     ;16 bit world for now
0260 8FC9                       LONGA ON
0261 8FC9 AF 54 00 E1           LDA   >IRQ_1SEC                ;Save 1 second vector
0262 8FCD 85 B2                 STA   ZIRQ_1SEC                ;
0263 8FCF AF 56 00 E1           LDA   >IRQ_1SEC+2              ;
0264 8FD3 85 B4                 STA   ZIRQ_1SEC+2              ;
0265 8FD5 4B                    PHK                            ;Bank number of interrupt code
0266 8FD6 A2 81                 LDX   #>CPINTHNDLR             ;Hi byte of address
0267 8FD8 DA                    PHX                            ;
0268 8FD9 68                    PLA                            ;Recall 16 bit bank num/hi byte
0269 8FDA 8F 56 00 E1           STA   >IRQ_1SEC+2              ;Change vector
0270 8FDE A9 5C C2              LDA   #CPINTHNDLR*256+$5C      ;Low byte of addr / JMP abs long
0271 8FE1 8F 54 00 E1           STA   >IRQ_1SEC                ;
0272 8FE5                       LONGA OFF
0273 8FE5 E2 30                 SEP   #$30                     ;8 bit world to continue
0274 8FE7 28                    PLP                            ;Re-enable ints with new vector installed
0275 8FE8
0276 8FE8 22 70 B9 FF           JSL   >READBR                  ;Read in user selections from BATTERYRAM
0277 8FEC 38                    SEC                            ;Set up everything EXCEPT slots
0278 8FED 22 94 00 E1           JSL   >TOBRAMSETUP             ;Setup batteryram choices
0279 8FF1
0280 8FF1              * Current RAM Disk size
0281 8FF1
0282 8FF1 A2 02                 LDX   #$02                     ;Push 4 bytes on stack for result
0283 8FF3 20 E6 A6              JSR   PUSH                     ;
0284 8FF6                       LONGI ON
0285 8FF6 A2 0D 0C              LDX   #GRDSZN*256+RDN          ;Function number/tool set number
0286 8FF9                       LONGI OFF
0287 8FF9 22 00 00 E1           JSL   >DISPATCH1               ;Go make total RAM call
0288 8FFD A3 01                 LDA   1,S                      ;Get size from stack
0289 8FFF 85 5C                 STA   CURRENTRAM               ;Save full 32 bits
0290 9001 A3 03                 LDA   3,S                      ;Save hi word too
0291 9003 85 5E                 STA   CURRENTRAM+2             ; and save in zero page for later
0292 9005
0293 9005              * Free RAM for RAM Disk = Total system RAM - 256K
0294 9005              *
0295 9005              * NOTE: 4 bytes were left on the stack from Current
0296 9005              *       RAM Disk size call.  The space they occupy
0297 9005              *       will be used for the total system RAM call.
0298 9005
0299 9005                       LONGI ON
0300 9005 A2 02 1D              LDX   #TMEMN*256+MMN           ;Function number/tool set number
0301 9008                       LONGI OFF
0302 9008 22 00 00 E1           JSL   >DISPATCH1               ;Go make total RAM call
0303 900C A3 01                 LDA   1,S                      ;Save 32 bits
0304 900E 85 50                 STA   TOTALSRAM                ;Save as total system RAM size
0305 9010 85 58                 STA   FREERAM                  ;Save as low byte of FREERAM too
0306 9012 A3 03                 LDA   3,S                      ;Save hi word too
0307 9014 85 52                 STA   TOTALSRAM+2              ;Save as total system RAM size
0308 9016 38                    SEC                            ;Subtract 256K
0309 9017                       LONGA ON
0310 9017 E9 04 00              SBC   #$0004                   ;256K is for system
0311 901A 85 5A                 STA   FREERAM+2                ;Save as Free RAM for RAM disk
0312 901C                       LONGA OFF
0313 901C D0 0C                 BNE   @1                       ;<>= then there is ram to work with
0314 901E 8F F6 02 E1           STA   >USERMRAM                ;00 variables because something's wrong!!!
0315 9022 E2 30                 SEP   #$30                     ;8 bit mode for call
0316 9024 22 80 00 E1           JSL   >TOWRITEBR               ;Write new parameter to BATTERYRAM
0317 9028 C2 30                 REP   #$30                     ;16 bit mode to continue
0318 902A
0319 902A              * RAM used for program = Total system RAM - Free system RAM
0320 902A              *
0321 902A              * NOTE: 4 bytes were left on the stack from Total
0322 902A              *       system RAM call.  The space they occupy
0323 902A              *       will be used for the free RAM call.
0324 902A
0325 902A              @1       EQU   *
0326 902A                       LONGI ON
0327 902A A2 02 1B              LDX   #FMEMN*256+MMN           ;Function number/tool set number
0328 902D                       LONGI OFF
0329 902D 22 00 00 E1           JSL   >DISPATCH1               ;Go make free RAM call
0330 9031 A3 01                 LDA   1,S                      ;Save as 32 bits
0331 9033 85 54                 STA   TOTALFRAM                ;Save as Total Free RAM
0332 9035 A3 03                 LDA   3,S                      ;Save hi word too
0333 9037 85 56                 STA   TOTALFRAM+2              ;Save as Total Free RAM
0334 9039 A5 50                 LDA   TOTALSRAM                ;
0335 903B 38                    SEC                            ;Prepare to subtract
0336 903C E5 54                 SBC   TOTALFRAM                ;Subtract total free RAM low byte
0337 903E 85 60                 STA   PROGRAMRAM               ;Save as RAM used by program size
0338 9040 A5 52                 LDA   TOTALSRAM+2              ;Now do high bytes
0339 9042 E5 56                 SBC   TOTALFRAM+2              ;
0340 9044 85 62                 STA   PROGRAMRAM+2             ;Save as RAM used by program size
0341 9046 68                    PLA                            ;Clean 4 bytes off the stack
0342 9047 68                    PLA                            ;
0343 9048 E2 30                 SEP   #$30                     ;Back to control panel mode
0344 904A
0345 904A 20 11 9A              JSR   TURNONMTXT               ;Enable printing of mouse text characters
0346 904D
0347 904D              * Clear screen and put line over main title position.
0348 904D
0349 904D A0 00                 LDY   #CPVPOSITION-1           ;Set up total screen clear
0350 904F 20 95 98              JSR   CLRTOBTM                 ;Clear to bottom of screen
0351 9052 A2 01                 LDX   #CPHPOSITION             ;Horizontal position
0352 9054 A0 00                 LDY   #CPVPOSITION-1           ;Vertical position
0353 9056 20 BD 93              JSR   FIXVTAB                  ;Move to position
0354 9059 A9 DF                 LDA   #BOTTOMLINE              ;Output 1 char to set OURCH if in 80 cols
0355 905B 20 C7 94              JSR   FILLREST                 ;Put in underline stuff
0356 905E
0357 905E A9 0B                 LDA   #CPQUIT-CPLN1            ;Point to QUIT option
0358 9060 85 00                 STA   CURSCRN                  ;Last main screen pointer position
0359 9062
0360 9062              * Restart main menu screen here
0361 9062
0362 9062              MAINMENU EQU   *                        ;Restart program here from submenus
0363 9062 78                    SEI                            ;Keep clock off til screen setup
0364 9063 A5 00                 LDA   CURSCRN                  ;Where should we point to?
0365 9065 85 01                 STA   CURLINE                  ;
0366 9067
0367 9067              * Change CURSCRN to point to main screen data
0368 9067
0369 9067 A9 0B                 LDA   #CPQUIT-CPLN1            ;Point to QUIT option
0370 9069 85 00                 STA   CURSCRN                  ;Last main screen pointer position
0371 906B
0372 906B              * Clear to bottom of screen
0373 906B
0374 906B A0 01                 LDY   #CPVPOSITION             ;Set up partial screen clear
0375 906D 20 95 98              JSR   CLRTOBTM                 ;Clear to bottom of screen
0376 9070
0377 9070              * Put up title
0378 9070
0379 9070 20 D7 93              JSR   PRTTITLE                 ;Print title
0380 9073 20 40 96              JSR   UNDERTITLE               ;Fill rest of line and underline it
0381 9076
0382 9076              * Set up some zero page parameters for
0383 9076              * submenu screens and indicator selection routines.
0384 9076
0385 9076 20 A8 98              JSR   GETSTATNUM               ;
0386 9079
0387 9079              * Put up border/footnotes/prompt boxes.
0388 9079
0389 9079 20 06 94              JSR   PRINTBORDER              ;Print border
0390 907C
0391 907C              * Put up main menu screen
0392 907C
0393 907C              SHWMAINMENU EQU   *                     ;Put up main menu
0394 907C A9 04                 LDA   #MPOSITION-1             ;Vertical position -1
0395 907E 85 25                 STA   CV                       ;
0396 9080 A9 1B                 LDA   #CPLN1                   ;1st line to print
0397 9082              @1       EQU   *
0398 9082 48                    PHA                            ;Save for testing if done
0399 9083 E6 25                 INC   CV                       ;Next vertical position
0400 9085 38                    SEC                            ;Calculate where we are
0401 9086 E9 1B                 SBC   #CPLN1                   ;
0402 9088 C5 01                 CMP   CURLINE                  ;Inverse if =
0403 908A D0 03                 BNE   @11                      ;
0404 908C 20 20 9A              JSR   TURNOFFMTXT              ;Enable printing inverse characters
0405 908F              @11      EQU   *
0406 908F A4 25                 LDY   CV                       ;'Y' contains vertical postn for FIXVTAB
0407 9091 A2 04                 LDX   #LNPOSITION              ;Horizontal tab
0408 9093 A3 01                 LDA   1,S                      ;Recall message number to print
0409 9095 20 D1 93              JSR   PRINTMSGXY               ;
0410 9098 20 11 9A              JSR   TURNONMTXT               ;Always reenable printing mouse text chars
0411 909B 68                    PLA                            ;
0412 909C 1A                    INC   A                        ;
0413 909D C9 27                 CMP   #CPLN1+MMLEN+0           ;
0414 909F 90 E1                 BCC   @1                       ;Loop til done
0415 90A1
0416 90A1 20 33 82              JSR   SELECTLINE               ;Select main menu option
0417 90A4 C9 8D                 CMP   #RETURNKEY               ;If return pressed go to submenu
0418 90A6 F0 13                 BEQ   RDYSBMENU                ;If return pressed do submenu stuff
0419 90A8 C9 9B                 CMP   #ESCKEY                  ;If Esc pressed move arrow to Quit option
0420 90AA F0 09                 BEQ   @16                      ;<>= then beep the user
0421 90AC C9 00                 CMP   #$00                     ;=0 then just redisplay screen
0422 90AE F0 CC                 BEQ   SHWMAINMENU              ;
0423 90B0 20 51 9A              JSR   NEWBELL1                 ;Indicate illegal key pressed
0424 90B3 80 C7                 BRA   SHWMAINMENU              ;Look for another key
0425 90B5
0426 90B5              @16      EQU   *
0427 90B5 A9 0B                 LDA   #CPQUIT-CPLN1            ;Force arrow to move to Quit option
0428 90B7 85 01                 STA   CURLINE                  ;
0429 90B9 80 C1                 BRA   SHWMAINMENU              ;Move to Quit
0430 90BB
0431 90BB              * Mark submenu chosen and test for Quit.
0432 90BB
0433 90BB              RDYSBMENU EQU   *
0434 90BB A6 01                 LDX   CURLINE                  ;Check for line number chosen
0435 90BD 86 00                 STX   CURSCRN                  ;Save as screen chosen
0436 90BF E0 0B                 CPX   #CPQUIT-CPLN1            ;Quit chosen?
0437 90C1 D0 29                 BNE   RDYSBMENU1               ;<>= then don't quit
0438 90C3
0439 90C3              * Exit Routine for Control Panel
0440 90C3
0441 90C3              NOTPASS  EQU   *
0442 90C3 08                    PHP                            ;Disable int while restoring vector
0443 90C4 78                    SEI                            ;
0444 90C5 A5 B1                 LDA   ZVGCINT                  ;Bit 2 hold 1-sec int enable bit
0445 90C7 8D 23 C0              STA   VGCINT                   ;Save for later
0446 90CA A5 B0                 LDA   ZKMSTATUS                ;Restore keyboard interrupt status
0447 90CC 8D 27 C0              STA   KMSTATUS                 ;
0448 90CF
0449 90CF C2 30                 REP   #$30                     ;16 bit world for now
0450 90D1                       LONGA ON
0451 90D1 A5 B2                 LDA   ZIRQ_1SEC                ;Restore 1 second vector
0452 90D3 8F 54 00 E1           STA   >IRQ_1SEC                ;
0453 90D7 A5 B4                 LDA   ZIRQ_1SEC+2              ;
0454 90D9 8F 56 00 E1           STA   >IRQ_1SEC+2              ;
0455 90DD                       LONGA OFF
0456 90DD E2 30                 SEP   #$30                     ;8 bit world to continue
0457 90DF 28                    PLP                            ;Re-enable ints with orig vector installed
0458 90E0
0459 90E0 38                    SEC                            ;'c'=1 indicates do NOT do slt designation
0460 90E1 22 94 00 E1           JSL   >TOBRAMSETUP             ;Reset setup parameters
0461 90E5
0462 90E5              RDYSBMENU0 EQU   *                      ;Called by text page 2 desk accessory
0463 90E5 68                    PLA                            ;Restore INTCXROM/SLOTCXROM
0464 90E6 30 03                 BMI   @1                       ;'-' then we stay in INTCXROM space
0465 90E8 8D 06 C0              STA   SETSLOTCXROM             ;'+' then switch back in SLOTCXROM space
0466 90EB              @1       EQU   *
0467 90EB 6B                    RTL                            ;Back to caller
0468 90EC
0469 90EC
0470 90EC              RDYSBMENU1 EQU   *
0471 90EC 78                    SEI                            ;Keep clock off til screen setup
0472 90ED
0473 90ED              * Before get to control panel submenu, update the original gs
0474 90ED              * maximum ramdisk option with the 're-size ramdisk during next
0475 90ED              * reset' value so that when changing with cursor, it would
0476 90ED              * point to the right batteryram buffer location without  
0477 90ED              * changing all the rest of the reference tables. When exits
0478 90ED              * from control panel, update it back !!!
0479 90ED
0480 90ED AF F8 02 E1           LDA   >USERRSTRAM              ;Get re-size option
0481 90F1 8F F7 02 E1           STA   >USERXRAM                ; save to maxi ramdisk to fool around  
0482 90F5
0483 90F5              * Also for slot submenu, update USERSLT1 with SPCLSLT1 so that all
0484 90F5              * printing can use USERSLT1 offset correctly.  When exiting from
0485 90F5              * slot submenu, then copy USERSLT1 to SPCLSLT1 and then update 
0486 90F5              * USERSLT1 for 0/1 so that AppleTalk can function properly with
0487 90F5              * System disk <= 4.0 but >= 3.2 !!!
0488 90F5
0489 90F5 AF 18 03 E1           LDA   >SPCLSLT1                ;Before enter submenu, update USERSLT1 w/
0490 90F9 8F E1 02 E1           STA   >USERSLT1                ;  this special slot1 byte 
0491 90FD
0492 90FD              * Undo main title indicator
0493 90FD
0494 90FD              @1       EQU   *
0495 90FD 20 D7 93              JSR   PRTTITLE                 ;Print title
0496 9100 20 C3 94              JSR   FILLSPACE                ;Fill rest of line with spaces
0497 9103
0498 9103              * Underline main title and overline submenu title
0499 9103
0500 9103 A2 00                 LDX   #CPHPOSITION-1           ;Put up separater
0501 9105 A0 02                 LDY   #CPVPOSITION+1           ;Vertical position
0502 9107 20 BD 93              JSR   FIXVTAB                  ;Move there
0503 910A 20 B7 94              JSR   FILLDBLBAR               ;Fill rest of line with double bar
0504 910D
0505 910D              * Underline submenu title
0506 910D
0507 910D A2 01                 LDX   #CPHPOSITION             ;Horizontal position of overline
0508 910F A0 04                 LDY   #SPOSITION-1             ;Underline submenu title
0509 9111 20 BB 94              JSR   FILLTOPLINE              ;
0510 9114
0511 9114              * Put up submenu title and submenu title indicator
0512 9114
0513 9114 A2 01                 LDX   #CPHPOSITION             ;Horizontal position
0514 9116 A0 03                 LDY   #SPOSITION-2             ;Vertical position
0515 9118 20 BD 93              JSR   FIXVTAB                  ;Move there
0516 911B 20 91 AC              JSR   PR1BLNKFF                ;Print a space
0517 911E 18                    CLC                            ;Calc msg num for title of submenu screen
0518 911F A5 00                 LDA   CURSCRN                  ;Screen number chosen is offset
0519 9121 69 1B                 ADC   #CPLN1                   ;Add starting message number
0520 9123 20 80 C0              JSR   PRINTMSG                 ;Print submenu title
0521 9126 20 BF 94              JSR   FILLINVSPACE             ;Fill rest of line with inverse space
0522 9129
0523 9129              * Clear submenu screen area.
0524 9129
0525 9129              RSTPORTMENU EQU   *
0526 9129 64 01                 STZ   CURLINE                  ;Start on 1st line always
0527 912B A0 04                 LDY   #SPOSITION-1             ;Clear from here
0528 912D 20 95 98              JSR   CLRTOBTM                 ;Clear to end of screen
0529 9130 A0 04                 LDY   #SPOSITION-1             ;Vertical position to start submenu screen
0530 9132 20 48 94              JSR   ADDBOTTOM2               ;Top line of submenu
0531 9135
0532 9135              * Setup submenu zero page variables
0533 9135
0534 9135 20 A8 98              JSR   GETSTATNUM               ;Set up submenu information
0535 9138
0536 9138              * Put up submenu border
0537 9138
0538 9138 20 06 94              JSR   PRINTBORDER              ;
0539 913B
0540 913B              * Get latest clock values
0541 913B
0542 913B A2 04                 LDX   #$04                     ;Push 8 bytes on stack
0543 913D 20 E6 A6              JSR   PUSH                     ;
0544 9140                       LONGI ON
0545 9140 A2 03 0D              LDX   #RTHFN*256+MTN           ;Function number/Misc Tool number
0546 9143                       LONGI OFF
0547 9143 22 00 00 E1           JSL   >DISPATCH1               ;Call main Tool Locator
0548 9147 E2 30                 SEP   #$30                     ;8 bit land a must now
0549 9149 68                    PLA                            ;Recall second count
0550 914A 85 6A                 STA   ZSECOND                  ;Save in zero page
0551 914C 68                    PLA                            ;Recall minute count
0552 914D 85 69                 STA   ZMINUTE                  ;Save in zero page
0553 914F 68                    PLA                            ;Recall 24 hour time
0554 9150 85 68                 STA   Z24HOUR                  ;Save in zero page
0555 9152
0556 9152 68                    PLA                            ;Recall year count
0557 9153 C9 64                 CMP   #$64                     ;If >= $64 (100 decimal) then subtract $64
0558 9155 90 02                 BCC   @123                     ;< then save without subtracting 100
0559 9157 E9 64                 SBC   #$64                     ;Offset for years >= the year 2000
0560 9159              @123     EQU   *
0561 9159 85 66                 STA   ZYEAR                    ;Save in zero page
0562 915B 68                    PLA                            ;Recall day count
0563 915C 85 65                 STA   ZDAY                     ;Save in zero page
0564 915E 68                    PLA                            ;Recall month count
0565 915F 85 64                 STA   ZMONTH                   ;Save in zero page
0566 9161 68                    PLA                            ;Eat null byte
0567 9162 68                    PLA                            ;Eat day of week
0568 9163 AF F4 02 E1           LDA   >USERDATE                ;Move to zero page
0569 9167 85 67                 STA   ZDATE                    ;
0570 9169 AF F5 02 E1           LDA   >USERAMPM                ;
0571 916D 85 6B                 STA   ZAMPM                    ;
0572 916F
0573 916F              * Put up submenu screen chosen
0574 916F
0575 916F 20 44 9A              JSR   PRTMODEM                 ;CHK for printer/modem screen
0576 9172 D0 05                 BNE   @125                     ;BRA if not 1st line of prt/modem
0577 9174 20 33 82              JSR   SELECTLINE               ;Fool to 2nd line 
0578 9177 80 07                 BRA   RSTSBMENU                ;Continue on
0579 9179              @125     EQU   *
0580 9179 64 02                 STZ   NEWLINE                  ;Be sure to inverse 1st item 1st line
0581 917B 20 58 96              JSR   PRINTSBMENU              ;Print submenu
0582 917E 64 01                 STZ   CURLINE                  ;Start on 1st submenu line always
0583 9180
0584 9180              * Select which line on submenu to act on
0585 9180
0586 9180              RSTSBMENU EQU   *
0587 9180 A5 01                 LDA   CURLINE                  ;Must preserve around PRINTSBMENU call
0588 9182 85 02                 STA   NEWLINE                  ;Save for print routine
0589 9184 48                    PHA                            ;
0590 9185 20 58 96              JSR   PRINTSBMENU              ;Print submenu
0591 9188 68                    PLA                            ;Recall CURLINE
0592 9189 85 01                 STA   CURLINE                  ; and restore.
0593 918B 20 33 82              JSR   SELECTLINE               ;Select submenu line number to do
0594 918E C9 00                 CMP   #$00                     ;=0 then reshow screen
0595 9190 F0 EE                 BEQ   RSTSBMENU                ;
0596 9192 C9 9B                 CMP   #ESCKEY                  ;Escape pressed then back to main menu
0597 9194 D0 08                 BNE   NOTESC                   ;
0598 9196              RSTSBMENU2 EQU   *
0599 9196 38                    SEC                            ;'c'=1 indicates do NOT do slt designation
0600 9197 22 94 00 E1           JSL   >TOBRAMSETUP             ;Reset setup parameters
0601 919B 4C 62 90              JMP   MAINMENU                 ;Restart main menu
0602 919E
0603 919E              NOTESC   EQU   *
0604 919E C9 8D                 CMP   #RETURNKEY               ;If return write data to BATTERYRAM
0605 91A0 F0 03                 BEQ   @11                      ;BRA if CR pressed
0606 91A2 4C 49 92              JMP   NOTCRETURN               ;
0607 91A5
0608 91A5              @11      EQU   *
0609 91A5 A5 00                 LDA   CURSCRN                  ;Which screen were we on?
0610 91A7 C9 03                 CMP   #CPLN4-CPLN1             ;If it's the time screen reset the clock
0611 91A9 D0 26                 BNE   @12                      ;
0612 91AB
0613 91AB A5 64                 LDA   ZMONTH                   ;Push month on stack for WriteTime call
0614 91AD 48                    PHA                            ;
0615 91AE A5 65                 LDA   ZDAY                     ;Push day on stack for WriteTime call
0616 91B0 48                    PHA                            ;
0617 91B1 A5 66                 LDA   ZYEAR                    ;Push year on stack for WriteTime call
0618 91B3 C9 28                 CMP   #40                      ;If =< then add $64
0619 91B5 B0 03                 BCS   @2                       ;
0620 91B7              @1       EQU   *                        ;Add $64 (100 decimal) to the year
0621 91B7 18                    CLC                            ;Clear carry to add
0622 91B8 69 64                 ADC   #$64                     ;Add offset
0623 91BA              @2       EQU   *
0624 91BA 48                    PHA                            ;
0625 91BB A5 68                 LDA   Z24HOUR                  ;Push hour on stack for WriteTime call
0626 91BD 48                    PHA                            ;
0627 91BE A5 69                 LDA   ZMINUTE                  ;Push minute on stack for WriteTime call
0628 91C0 48                    PHA                            ;
0629 91C1 A5 6A                 LDA   ZSECOND                  ;Push second on stack for WriteTime call
0630 91C3 48                    PHA                            ;
0631 91C4 C2 30                 REP   #$30                     ;16 bit land a must for tool calls
0632 91C6                       LONGI ON
0633 91C6 A2 03 0E              LDX   #WTHFN*256+MTN           ;Function number*256 + Misc Tool number
0634 91C9                       LONGI OFF
0635 91C9 22 00 00 E1           JSL   >DISPATCH1               ;Call main Tool Locator
0636 91CD E2 30                 SEP   #$30                     ;Back to 8 bit land
0637 91CF
0638 91CF 80 0F                 BRA   @18                      ;
0639 91D1              @12      EQU   *
0640 91D1 C9 08                 CMP   #CPLN9-CPLN1             ;If it's RAM Disk then send parameters
0641 91D3 D0 0B                 BNE   @18                      ;Skip RAM Disk parameter send stuff
0642 91D5              @13      EQU   *
0643 91D5 C2 30                 REP   #$30                     ;16 bit land required for all tool calls
0644 91D7                       LONGI ON
0645 91D7 A2 0D 0B              LDX   #SRDSZN*256+RDN          ;Function num*256 + RAM Disk call num
0646 91DA                       LONGI OFF
0647 91DA 22 00 00 E1           JSL   >DISPATCH1               ;Go through tool locator
0648 91DE E2 30                 SEP   #$30                     ;Back to 8 bit land
0649 91E0
0650 91E0              @18      EQU   *
0651 91E0 20 93 95              JSR   WARNPROMPT               ;Maybe put up a warning prompt
0652 91E3 B0 9B                 BCS   RSTSBMENU                ;Restart same screen
0653 91E5
0654 91E5 AF F7 02 E1           LDA   >USERXRAM
0655 91E9 8F F8 02 E1           STA   >USERRSTRAM
0656 91ED F0 06                 BEQ   @20_1
0657 91EF A9 00                 LDA   #$00
0658 91F1 8F FF 15 E1           STA   >RAMDSKPWRUP
0659 91F5              @20_1    EQU   *
0660 91F5 AF F6 02 E1           LDA   >USERMRAM
0661 91F9 8F F7 02 E1           STA   >USERXRAM
0662 91FD
0663 91FD              * If slot screen is properly sets up, then need to copy USERSLT1 to
0664 91FD              * SPCLSLT1 and then play around for USERSLT1 so that AppleTalk can
0665 91FD              * function properly with System disk <= 4.0 !!!
0666 91FD              * If slot7 is set to 'Your Card', then USERSLT1 = SPCLSLT1 
0667 91FD              * Also needs to update 'Device Connected' in Printer Port/Modem
0668 91FD              * Port respectively since users can't change it.  
0669 91FD
0670 91FD AF E1 02 E1           LDA   >USERSLT1                ;Update SPCLSLT1 w/ USERSLT1
0671 9201 8F 18 03 E1           STA   >SPCLSLT1                ; 
0672 9205 AA                    TAX                            ;Save 'A'
0673 9206 F0 0D                 BEQ   @22                      ;BRA for 'printer,0' -> 'printer,0'
0674 9208 3A                    DEC   A                        ;
0675 9209 F0 07                 BEQ   @26                      ;BRA for 'Your Card,1' -> 'Your Card,3'
0676 920B 3A                    DEC   A                        ;
0677 920C F0 05                 BEQ   @24                      ;BRA for 'AppleTalk,2' -> 'AppleTalk,2'
0678 920E 3A                    DEC   A                        ;
0679 920F F0 03                 BEQ   @25                      ;Should be 'Modem,3' -> 'Modem,1'
0680 9211 3A                    DEC   A
0681 9212              @26      EQU   *
0682 9212 1A                    INC   A
0683 9213              @24      EQU   *
0684 9213 1A                    INC   A                        ;
0685 9214              @25      EQU   *
0686 9214 1A                    INC   A
0687 9215              @22      EQU   *
0688 9215 8F C0 02 E1           STA   >USERPORT1               ;Set proper value for USERPORT1
0689 9219
0690 9219              @23      EQU   *
0691 9219 AF E2 02 E1           LDA   >USERSLT2                ;DO the same for slot2 and Modem Port
0692 921D F0 0C                 BEQ   @31                      ;BRA for 'Modem, 0 ' -> 'Modem, 1'
0693 921F 3A                    DEC   A                        ;
0694 9220 F0 07                 BEQ   @36                      ;Bra for 'Your Card, 1' -> 'Your Card,3'
0695 9222 3A                    DEC   A                        ;
0696 9223 F0 05                 BEQ   @32                      ;BRA for 'AppleTalk, 2' -> 'ApTalk,2'
0697 9225 3A                    DEC   A                        ;
0698 9226 F0 04                 BEQ   @33                      ;BRA for 'Printer, 3' -> 'Printer,0'
0699 9228 3A                    DEC   A
0700 9229              @36      EQU   *
0701 9229 1A                    INC   A
0702 922A              @32      EQU   *
0703 922A 1A                    INC   A
0704 922B              @31      EQU   *
0705 922B 1A                    INC   A
0706 922C              @33      EQU   *
0707 922C 8F CC 02 E1           STA   >USERPORT2               ;Update it
0708 9230              @35      EQU   *
0709 9230 AF E7 02 E1           LDA   >USERSLT7                ;Get slot7 configuration
0710 9234 D0 0C                 BNE   @19                      ;BRA if set to 'Your Card'
0711 9236 8A                    TXA                            ;Get back 'A'
0712 9237 C9 02                 CMP   #$02                     ;Is slot1 selected for ApTalk
0713 9239 F0 02                 BEQ   @20                      ;If 2, make it 1 for 'Your Card'
0714 923B A9 01                 LDA   #$01                     ;Else make it $00, other than ApTalk
0715 923D              @20      EQU   *
0716 923D 3A                    DEC   A                        ;Adjust for old ApTalk Disk to run
0717 923E 8F E1 02 E1           STA   >USERSLT1                ;Update it
0718 9242              @19      EQU   *
0719 9242 22 80 00 E1           JSL   >TOWRITEBR               ;Write info from BRAM buff to BATTERYRAM
0720 9246 4C 96 91              JMP   RSTSBMENU2               ;Restart same menu after setup
0721 9249
0722 9249              NOTCRETURN EQU   *
0723 9249 48                    PHA                            ;Save key pressed
0724 924A 24 1F                 BIT   STATBYTE                 ;Bit 6 = normal/special change function
0725 924C 70 5B                 BVS   SPECCHANGE               ;'v'=1 then special change function
0726 924E              RDYTSTKEY EQU   *
0727 924E 20 8A 99              JSR   GETUSROPT0               ;Get option shown currently on screen
0728 9251 FA                    PLX                            ;Recall keypressed
0729 9252 20 5B 92              JSR   TSTKEYNOW                ;Now test key pressed
0730 9255 20 93 95              JSR   WARNPROMPT               ;Maybe put up a warning prompt
0731 9258 4C 80 91              JMP   RSTSBMENU                ;Restart submenu screen
0732 925B
0733 925B              TSTKEYNOW EQU   *
0734 925B E0 88                 CPX   #LEFTAKEY                ;Test for left or right arrow
0735 925D F0 2A                 BEQ   DECOPTION                ;Decrement option if left arrow
0736 925F AA                    TAX                            ;Save 'a'
0737 9260 20 D5 82              JSR   CHKGSC                   ;Check for GSc machine
0738 9263 B0 0E                 BCS   @1                       ;BRA if not
0739 9265 A5 01                 LDA   CURLINE                  ;What line of slot screen ?
0740 9267 F0 04                 BEQ   @2                       ;
0741 9269 C9 01                 CMP   #$01                     ;
0742 926B D0 06                 BNE   @1
0743 926D              @2       EQU   *
0744 926D 8A                    TXA                            ;CHK if currently at 'default one'
0745 926E D0 04                 BNE   @11
0746 9270 1A                    INC   A                        ;Else add one more to skip over
0747 9271 80 01                 BRA   @11                      ;
0748 9273              @1       EQU   *
0749 9273 8A                    TXA   
0750 9274              @11      EQU   *
0751 9274 1A                    INC   A                        ;Increment to next option
0752 9275 C5 05                 CMP   NUMOPTS                  ;If at max then wrap to first item
0753 9277 90 02                 BCC   LRNORMEXIT               ;< then no right arrow wrapping
0754 9279 A9 00                 LDA   #$00                     ;Minimum option number = 0
0755 927B
0756 927B              LRNORMEXIT EQU   *                      ;Left/right arrow normal exit
0757 927B 97 AD                 STA   [BRAMPTR],Y              ;Save back as new user option
0758 927D 18                    CLC                            ;Clear carry to add
0759 927E A5 01                 LDA   CURLINE                  ;Calculate message number of line were on
0760 9280 AA                    TAX                            ;Save in 'X' for PRINTLINE
0761 9281 65 A3                 ADC   NUMFIRSTLN               ;Offset + 1st line msg # = correct msg num
0762 9283 20 80 96              JSR   PRINTLINE                ;Print line
0763 9286 4C B5 96              JMP   PRINTOPTION              ;Print line's new option
0764 9289
0765 9289              DECOPTION EQU   *                       ;Left arrow was pressed if here
0766 9289 AA                    TAX                            ;Sets 'z'
0767 928A D0 04                 BNE   @1                       ;= then left arrow wrap must occur
0768 928C A5 05                 LDA   NUMOPTS                  ;Pick up max option number to wrap
0769 928E 80 16                 BRA   @11
0770 9290              @1       EQU   *
0771 9290 20 D5 82              JSR   CHKGSC
0772 9293 B0 10                 BCS   @2
0773 9295 A5 01                 LDA   CURLINE
0774 9297 F0 04                 BEQ   @3
0775 9299 C9 01                 CMP   #$01
0776 929B D0 08                 BNE   @2
0777 929D              @3       EQU   *
0778 929D 8A                    TXA   
0779 929E C9 02                 CMP   #$02
0780 92A0 D0 04                 BNE   @11
0781 92A2 3A                    DEC   A
0782 92A3 80 01                 BRA   @11
0783 92A5              @2       EQU   *
0784 92A5 8A                    TXA   
0785 92A6              @11      EQU   *
0786 92A6 3A                    DEC   A                        ;Decrement to next option
0787 92A7 80 D2                 BRA   LRNORMEXIT               ;Exit through common exit point
0788 92A9
0789 92A9
0790 92A9              SPECCHANGE EQU   *                      ;'v'=1 then special change function
0791 92A9 20 8A 99              JSR   GETUSROPT0               ;Get option shown currently on screen
0792 92AC A6 00                 LDX   CURSCRN                  ;Which screen we on?
0793 92AE F0 16                 BEQ   CHDISP                   ;=0 then its display screen change
0794 92B0 E0 01                 CPX   #CPLN2-CPLN1             ;
0795 92B2 F0 5E                 BEQ   CHSOUND                  ;= then its sound screen change
0796 92B4 E0 03                 CPX   #CPLN4-CPLN1             ;
0797 92B6 F0 08                 BEQ   @1                       ;= then its clock screen change
0798 92B8 E0 08                 CPX   #CPLN9-CPLN1             ;
0799 92BA F0 07                 BEQ   @2                       ;= then its ramdisk screen change
0800 92BC 68                    PLA                            ;Recall keypress from stack
0801 92BD 4C 62 90              JMP   MAINMENU                 ;Return to main menu for now
0802 92C0
0803 92C0              @1       EQU   *
0804 92C0 4C 61 93              JMP   CHCLOCK                  ;Off to change clock routine
0805 92C3
0806 92C3              @2       EQU   *
0807 92C3 4C 35 93              JMP   CHRAMDSK                 ;Off to change ramdisk routine
0808 92C6
0809 92C6
0810 92C6              CHDISP   EQU   *                        ;Display screen change requested
0811 92C6 A5 01                 LDA   CURLINE                  ;Which line we on?
0812 92C8 C9 06                 CMP   #DISPLN7-DISPLN1         ;On 'Standards' line?
0813 92CA D0 10                 BNE   @10                      ;<>= then don't put up standard colors
0814 92CC 68                    PLA                            ;Pull keystroke from stack
0815 92CD A2 02                 LDX   #2                       ;Move 3 bytes
0816 92CF              @13      EQU   *
0817 92CF BF DF 83 FF           LDA   >DISPDFTT,X              ;Default parameters
0818 92D3 9F DA 02 E1           STA   >USERTEXT,X              ;Save as new user parameters
0819 92D7 CA                    DEX                            ;
0820 92D8 10 F5                 BPL   @13                      ;Loop til 3 bytes moved
0821 92DA 80 1B                 BRA   @12                      ;
0822 92DC
0823 92DC              @10      EQU   *
0824 92DC C9 02                 CMP   #DISPLN3-DISPLN1         ;< then do normally
0825 92DE B0 03                 BCS   @11                      ;> or = then special stuff
0826 92E0 4C 4E 92              JMP   RDYTSTKEY                ;Go to normal loop
0827 92E3
0828 92E3              @11      EQU   *
0829 92E3 20 8A 99              JSR   GETUSROPT0               ;Get option shown currently on screen
0830 92E6 FA                    PLX                            ;Recall keypressed
0831 92E7 E0 88                 CPX   #LEFTAKEY                ;Test for left or right arrow
0832 92E9 F0 1A                 BEQ   @14                      ;Decrement option if left arrow
0833 92EB              @11_1    EQU   *
0834 92EB 1A                    INC   A                        ;Increment to next option
0835 92EC C5 05                 CMP   NUMOPTS                  ;If at max then wrap to first item
0836 92EE 90 02                 BCC   @11_2                    ;< then no right arrow wrapping
0837 92F0 A9 00                 LDA   #$00                     ;Minimum option number=0
0838 92F2
0839 92F2              @11_2    EQU   *                        ;Left/right arrow normal exit
0840 92F2 20 F4 99              JSR   TSTTXTBGD                ;Test text color vs background color
0841 92F5 B0 F4                 BCS   @11_1                    ;'c'=1 then increment one more time
0842 92F7              @12      EQU   *                        ;Left/right arrow normal exit
0843 92F7 A5 01                 LDA   CURLINE                  ;Save line number we're on
0844 92F9 48                    PHA                            ;
0845 92FA A0 05                 LDY   #SPOSITION               ;Vertical position for 1st line
0846 92FC 84 25                 STY   CV                       ;
0847 92FE 64 01                 STZ   CURLINE                  ;Needed to redraw screen
0848 9300 20 18 97              JSR   DISPSBM                  ;
0849 9303 80 4A                 BRA   BK2SBMENU                ;Restart submenu
0850 9305
0851 9305              @14      EQU   *                        ;Left arrow was pressed if here
0852 9305 AA                    TAX                            ;Sets 'z'
0853 9306 D0 02                 BNE   @16                      ;= then left arrow wrap must occur
0854 9308 A5 05                 LDA   NUMOPTS                  ;Pick up max option number to wrap
0855 930A              @16      EQU   *
0856 930A 3A                    DEC   A                        ;Decrement to next option
0857 930B 20 F4 99              JSR   TSTTXTBGD                ;Test text color vs background color
0858 930E B0 F5                 BCS   @14                      ;'c'=1 then decrement one more time
0859 9310 80 E5                 BRA   @12                      ;Exit through common exit point
0860 9312
0861 9312
0862 9312              CHSOUND  EQU   *                        ;Sound screen change requested
0863 9312 FA                    PLX                            ;Recall keypress from stack
0864 9313 20 5B 92              JSR   TSTKEYNOW                ;Test key end do option change
0865 9316
0866 9316 AD 3C C0              LDA   SOUNDCTL                 ;Change low nybble only
0867 9319 29 F0                 AND   #$F0                     ;
0868 931B 0F DE 02 E1           ORA   >USERVOL                 ;What's user volume?
0869 931F 8D 3C C0              STA   SOUNDCTL                 ;Alter user's volume
0870 9322 29 0F                 AND   #$0F                     ;What's user volume?
0871 9324 8F CA 00 E1           STA   >IRQ_VOLUME              ;Save as new interrupt manager value
0872 9328 0A                    ASL   A                        ;Shift to hi nybble for Ensoniq routines
0873 9329 0A                    ASL   A                        ;
0874 932A 0A                    ASL   A                        ;
0875 932B 0A                    ASL   A                        ;
0876 932C 8F B0 1D E1           STA   >SYSVOLLOC               ;Save for Ensoniq sound routines
0877 9330
0878 9330 20 51 9A              JSR   NEWBELL1                 ;Let user hear new volume/chimes
0879 9333 80 1D                 BRA   BK2SBMENU2               ;Return to sub menu for now
0880 9335
0881 9335
0882 9335              CHRAMDSK EQU   *                        ;Ramdisk screen change
0883 9335 FA                    PLX                            ;Recall ke}pressed
0884 9336 E0 88                 CPX   #LEFTAKEY                ;Test for left or right arrow
0885 9338 F0 1B                 BEQ   CHRAMDISK6               ;Decrement option if left arrow
0886 933A 1A                    INC   A                        ;Increment to next option
0887 933B A6 05                 LDX   NUMOPTS                  ;If 0 then wrapping is automatic
0888 933D F0 06                 BEQ   CHRAMDISK2               ;
0889 933F C5 05                 CMP   NUMOPTS                  ;If at max then wrap to first item
0890 9341 90 02                 BCC   CHRAMDISK2               ;< then no right arrow wrapping
0891 9343 A9 00                 LDA   #$00                     ;Minimum option number=0
0892 9345
0893 9345              CHRAMDISK2 EQU   *                      ;Left/right arrow normal exit
0894 9345 97 AD                 STA   [BRAMPTR],Y              ;Set maxi option = mini option
0895 9347
0896 9347 A5 01                 LDA   CURLINE                  ;Remember which line we're on
0897 9349 48                    PHA                            ;
0898 934A 64 01                 STZ   CURLINE                  ;Needed to redraw screen
0899 934C 20 A3 97              JSR   RAMDSKSBM                ;Reshow sceen
0900 934F              BK2SBMENU EQU   *                       ;Return to current submenu
0901 934F 68                    PLA                            ;Recall user's line number
0902 9350 85 01                 STA   CURLINE                  ;
0903 9352              BK2SBMENU2 EQU   *                      ;Return to current submenu
0904 9352 4C 80 91              JMP   RSTSBMENU                ;Restart screen
0905 9355
0906 9355              CHRAMDISK6 EQU   *                      ;Left arrow was pressed if here
0907 9355 AA                    TAX                            ;Sets 'z'
0908 9356 D0 06                 BNE   @18                      ;= then left arrow wrap must occur
0909 9358 A6 05                 LDX   NUMOPTS                  ;If 0 then wrapping is automatic
0910 935A F0 02                 BEQ   @18                      ;
0911 935C A5 05                 LDA   NUMOPTS                  ;Pick up max option number to wrap
0912 935E              @18      EQU   *
0913 935E 3A                    DEC   A                        ;Decrement to next option
0914 935F 80 E4                 BRA   CHRAMDISK2               ;Exit through common exit point
0915 9361
0916 9361
0917 9361              CHCLOCK  EQU   *                        ;Clock screen change
0918 9361 20 97 93              JSR   GOCHECKDAY               ;Go check day
0919 9364 B9 64 00              LDA   |ZMONTH,Y                ;Get current option value
0920 9367 FA                    PLX                            ;Recall keypressed
0921 9368 E0 88                 CPX   #LEFTAKEY                ;Test for left or right arrow
0922 936A F0 23                 BEQ   @16                      ;Decrement option if left arrow
0923 936C 1A                    INC   A                        ;Increment to next option
0924 936D C5 05                 CMP   NUMOPTS                  ;If at max then wrap to first item
0925 936F 90 02                 BCC   @12                      ;< then no right arrow wrapping
0926 9371 A9 00                 LDA   #$00                     ;Minimum option number=0
0927 9373
0928 9373              @12      EQU   *                        ;Left/right arrow normal exit
0929 9373 99 64 00              STA   |ZMONTH,Y                ;Save back in zero page
0930 9376
0931 9376 A5 67                 LDA   ZDATE                    ;Move to user save area
0932 9378 8F F4 02 E1           STA   >USERDATE                ;
0933 937C A5 6B                 LDA   ZAMPM                    ;
0934 937E 8F F5 02 E1           STA   >USERAMPM                ; for use by scveen display.
0935 9382
0936 9382 A5 01                 LDA   CURLINE                  ;Remember which line we're on
0937 9384 48                    PHA                            ;
0938 9385 64 01                 STZ   CURLINE                  ;Needed to redraw screen
0939 9387 20 97 93              JSR   GOCHECKDAY               ;Modify day if needed
0940 938A 20 FB 97              JSR   RSTCLOCKSBM              ;Reshow sceen
0941 938D 80 C0                 BRA   BK2SBMENU                ;Restart screen
0942 938F
0943 938F              @16      EQU   *                        ;Left arrow was pressed if here
0944 938F AA                    TAX                            ;Sets 'z'
0945 9390 D0 02                 BNE   @18                      ;= then left arrow wrap must occur
0946 9392 A5 05                 LDA   NUMOPTS                  ;Pick up max option number to wrap
0947 9394              @18      EQU   *
0948 9394 3A                    DEC   A                        ;Decrement to next option
0949 9395 80 DC                 BRA   @12                      ;Exit through common exit point
0950 9397
0951 9397              GOCHECKDAY EQU   *
0952 9397 C0 03                 CPY   #CLOCKLN4-CLOCKLN1       ;On month/day/}ear line?
0953 9399 B0 1F                 BCS   @11_8                    ;If not, use NUMOPTS already calculated
0954 939B A6 64                 LDX   ZMONTH                   ;What's the current month?
0955 939D A5 66                 LDA   ZYEAR                    ;What's the current year?
0956 939F 29 03                 AND   #$03                     ;Leap year?
0957 93A1 D0 06                 BNE   @123                     ; Nope
0958 93A3 E0 01                 CPX   #$01                     ;If yes, is it February
0959 93A5 D0 02                 BNE   @123                     ;Nope
0960 93A7 A2 0C                 LDX   #$0C                     ;If February and leap year.
0961 93A9              @123     EQU   *
0962 93A9 BF B7 83 FF           LDA   >MONTHLEN,X              ;Get maximum days in month
0963 93AD C0 01                 CPY   #CLOCKLN2-CLOCKLN1       ;Are we on day line?
0964 93AF D0 02                 BNE   @11_2                    ;No then don't change NUMOPTS
0965 93B1 85 05                 STA   NUMOPTS                  ;Save as new number of options
0966 93B3              @11_2    EQU   *
0967 93B3 3A                    DEC   A                        ;'A' contains real day+1 to start
0968 93B4 C5 65                 CMP   ZDAY                     ;?Test current day against maximum
0969 93B6 B0 02                 BCS   @11_8                    ;>= then all's OK
0970 93B8 85 65                 STA   ZDAY                     ;
0971 93BA              @11_8    EQU   *
0972 93BA 60                    RTS                            ;Back to caller
0973 93BB
0974 93BB
0975 93BB
0976 93BB
0977 93BB                       TITLE 'Print Subroutines'
0978 93BB
0979 93BB              ******************************************************
0980 93BB              *                                                    *
0981 93BB              * Print Subroutines for Control Panel Desk Accessory *
0982 93BB              *                                                    *
0983 93BB              *                    by                              *
0984 93BB              *               Fern Bachman     1985-1987           *
0985 93BB              *               Joe Bo           1987-1989           *
0986 93BB              *                                                    *
0987 93BB              *       Copyright Apple Computer, Inc. 1985-1989     *
0988 93BB              *                All Rights Reserved.                *
0989 93BB              *                                                    *
0990 93BB              ******************************************************
0991 93BB
0992 93BB
0993 93BB              FIXVTAB0X EQU   *                       ;Start at left side of screen
0994 93BB A2 00                 LDX   #$00                     ;To do that 'X' must be $00
0995 93BD              FIXVTAB  EQU   *
0996 93BD 48                    PHA                            ;Save 'A'
0997 93BE 8A                    TXA                            ;Maybe change horizontal offset?
0998 93BF 18                    CLC                            ;
0999 93C0 2C 1F C0              BIT   RD80VID                  ;Are we using 80 columns?
1000 93C3 10 02                 BPL   @1                       ;+ then we aren't.
1001 93C5 69 14                 ADC   #20                      ;Add 20 byte horizontal offset
1002 93C7              @1       EQU   *
1003 93C7 AA                    TAX                            ;Move horizontal position to 'X'
1004 93C8 20 E0 A9              JSR   SETVTAB                  ;Move there
1005 93CB 68                    PLA                            ;Recall print index
1006 93CC 60                    RTS                            ;Back to caller
1007 93CD
1008 93CD
1009 93CD              PRTTOPBOX EQU   *                       ;Print top of box
1010 93CD A9 16                 LDA   #TOPBOX                  ;Top of box message number
1011 93CF
1012 93CF              PRTMSGXPR EQU   *                       ;Print box starting at PRPOSITION
1013 93CF A2 17                 LDX   #PRPOSITION              ;Horizontal box position
1014 93D1
1015 93D1              PRINTMSGXY EQU   *
1016 93D1 20 BD 93              JSR   FIXVTAB                  ;Fix up print position
1017 93D4              GOPRINTMSG EQU   *
1018 93D4 4C 80 C0              JMP   PRINTMSG                 ;Print approprmate message
1019 93D7
1020 93D7
1021 93D7              PRTTITLE EQU   *                        ;Print title
1022 93D7 A2 01                 LDX   #CPHPOSITION             ;HTAB position
1023 93D9 A0 01                 LDY   #CPVPOSITION             ;Vertical position
1024 93DB A9 0E                 LDA   #CPTITLE                 ;Print title
1025 93DD 80 F2                 BRA   PRINTMSGXY               ;Exit via print routine
1026 93DF
1027 93DF
1028 93DF              PRTOPT   EQU   *                        ;Print an option
1029 93DF 18                    CLC                            ;Calculate message number
1030 93E0 B7 A4                 LDA   [OPTPTR],Y               ;Starting option number
1031 93E2 77 AD                 ADC   [BRAMPTR],Y              ;Add user option as offset to 1st msg num
1032 93E4 80 EE                 BRA   GOPRINTMSG               ;Print option message
1033 93E6
1034 93E6
1035 93E6              PRINTEDGES EQU   *                      ;Print sides of border
1036 93E6 A0 01                 LDY   #CPVPOSITION             ;Vertical position to start all borders
1037 93E8              @1       EQU   *
1038 93E8 5A                    PHY                            ;Wave vertical position
1039 93E9 20 BB 93              JSR   FIXVTAB0X                ;Left border of screen
1040 93EC A9 5A                 LDA   #RIGHTLINE               ;Left side border
1041 93EE 20 D1 A9              JSR   COUTFF                   ;
1042 93F1 7A                    PLY                            ;Recall vertical position
1043 93F2 5A                    PHY                            ; and resave it.
1044 93F3 A2 27                 LDX   #$27                     ;Right side of screen
1045 93F5 20 BD 93              JSR   FIXVTAB                  ;
1046 93F8 A9 5F                 LDA   #LEFTLINE                ;Right side border
1047 93FA 20 D1 A9              JSR   COUTFF                   ;
1048 93FD 7A                    PLY                            ;Recall vertical position
1049 93FE C8                    INY                            ;Next line down
1050 93FF C0 16                 CPY   #FNPOSITION              ;Border edges to FNPOSITION
1051 9401 90 E5                 BCC   @1                       ;
1052 9403 F0 E3                 BEQ   @1                       ;Loop on = too
1053 9405 60                    RTS                            ;Back to caller
1054 9406
1055 9406              PRINTBORDER EQU   *
1056 9406 20 E6 93              JSR   PRINTEDGES               ;Print edges of border
1057 9409
1058 9409              * Determine which footnote to display and display it
1059 9409
1060 9409 A2 02                 LDX   #CPHPOSITION+1           ;Horizontal position
1061 940B A0 16                 LDY   #FNPOSITION              ;Vertical position
1062 940D A9 0F                 LDA   #TOSELUSE                ;Always print 'Select:'
1063 940F 20 D1 93              JSR   PRINTMSGXY               ;Print footnotes
1064 9412
1065 9412 A5 00                 LDA   CURSCRN                  ;Main screen then print ^ v only
1066 9414 C9 0B                 CMP   #CPQUIT-CPLN1            ;Same as Quit option then on main screen
1067 9416 F0 0B                 BEQ   @1                       ; if main screen then print$^ v only
1068 9418
1069 9418 A9 11                 LDA   #LRSEL                   ;Message number
1070 941A 20 80 C0              JSR   PRINTMSG                 ;Print it
1071 941D A5 04                 LDA   NUMLINES                 ;Test number of lines to determine prompts
1072 941F C9 01                 CMP   #$01                     ;= then < > else < > ^ v
1073 9421 F0 05                 BEQ   @2                       ;No more footnote if = 
1074 9423
1075 9423              @1       EQU   *
1076 9423 A9 10                 LDA   #UDSEL                   ;Message number
1077 9425 20 80 C0              JSR   PRINTMSG                 ;Print it
1078 9428
1079 9428              @2       EQU   *
1080 9428 A5 1F                 LDA   STATBYTE                 ;Check which boxes to display
1081 942A 29 30                 AND   #$30                     ;Bit4=Open-Cancel/Sve | Bit5=no clk or clk
1082 942C 0A                    ASL   A                        ;Shift into 'c'/bit 7
1083 942D 0A                    ASL   A                        ;
1084 942E 0A                    ASL   A                        ;
1085 942F 08                    PHP                            ;Save status for clock checking later
1086 9430 30 04                 BMI   DOCANSVE                 ;'-' then cancel/save
1087 9432
1088 9432 A9 12                 LDA   #OPENCR                  ;?Message
1089 9434 80 07                 BRA   PRINTBORDER4             ;
1090 9436
1091 9436              DOCANSVE EQU   *
1092 9436 A9 14                 LDA   #CANCELESC               ;Message
1093 9438 20 80 C0              JSR   PRINTMSG                 ;Print message
1094 943B
1095 943B A9 13                 LDA   #SAVECR                  ;Message
1096 943D
1097 943D              PRINTBORDER4 EQU   *
1098 943D 20 80 C0              JSR   PRINTMSG                 ;Print message
1099 9440 28                    PLP                            ;Recall clock status
1100 9441 90 03                 BCC   ADDBOTTOM                ;'c'=0 then no clock
1101 9443 20 52 94              JSR   PRINTCLK                 ;'c'=1 then print cloco box
1102 9446
1103 9446
1104 9446              ADDBOTTOM EQU   *
1105 9446 A0 17                 LDY   #FNPOSITION+1            ;Vertical position
1106 9448              ADDBOTTOM2 EQU   *
1107 9448 A2 01                 LDX   #$01                     ;Start in first column
1108 944A 20 BD 93              JSR   FIXVTAB                  ;
1109 944D A9 4C                 LDA   #TOPLINE                 ;Bottom line char is TOPLINE
1110 944F 4C C7 94              JMP   FILLREST                 ;Finish bottom in this routine
1111 9452
1112 9452
1113 9452              * Print clock box, read time and display time in clock box
1114 9452
1115 9452              PRINTCLK EQU   *                        ;Print Clock in box
1116 9452 A0 05                 LDY   #CLKPOSITION             ;Vertical position
1117 9454 20 CD 93              JSR   PRTTOPBOX                ;Print top of box
1118 9457
1119 9457 A0 06                 LDY   #CLKPOSITION+1           ;Vertical position
1120 9459 A9 15                 LDA   #SPACEBOX                ;Message
1121 945B 20 CF 93              JSR   PRTMSGXPR                ;Print message at PRPOSITION
1122 945E
1123 945E A0 07                 LDY   #CLKPOSITION+2           ;Vertical position
1124 9460 A9 15                 LDA   #SPACEBOX                ;Message
1125 9462 20 CF 93              JSR   PRTMSGXPR                ;Print message at PRPOSITION
1126 9465
1127 9465              PRINTCLK0 EQU   *                       ;Interrupt entry point
1128 9465 08                    PHP                            ;No interrupts in here
1129 9466 78                    SEI                            ;
1130 9467
1131 9467 C2 30                 REP   #$30                     ;16 bit land a must for tool call
1132 9469 F4 00 00              PEA   $0000                    ;Sets up ASCII time (Null byte and bank)
1133 946C F4 6F 00              PEA   CASCIITIME               ;Address of buffer
1134 946F                       LONGI ON
1135 946F A2 03 0F              LDX   #RATFN*256+MTN           ;Function number/Misc Tool number
1136 9472                       LONGI OFF
1137 9472 22 00 00 E1           JSL   >DISPATCH1               ;Call main Tool Locator
1138 9476
1139 9476 E2 30                 SEP   #$30                     ;8 bit land a must now
1140 9478
1141 9478 A2 19                 LDX   #PRPOSITION+2            ;Horizontal position
1142 947A A0 06                 LDY   #CLKPOSITION+1           ;Time line
1143 947C 20 BD 93              JSR   FIXVTAB                  ;
1144 947F AF F5 02 E1           LDA   >USERAMPM                ;0='AM/PM' - 1='24 HR'
1145 9483 F0 03                 BEQ   @2                       ;=0 then don't change offset
1146 9485 20 91 AC              JSR   PR1BLNKFF                ;Print a blank to offset by 1
1147 9488              @2       EQU   *
1148 9488 A2 09                 LDX   #TIME-CASCIITIME         ;Move first byte on first
1149 948A              @4       EQU   *
1150 948A BF 6F 00 00           LDA   >CASCIITIME,X            ;
1151 948E DA                    PHX                            ;Preserve 'X' index
1152 948F 20 D1 A9              JSR   COUTFF                   ;Print character to screen
1153 9492 FA                    PLX                            ;Recall 'X'
1154 9493 E8                    INX                            ;Decrement counter
1155 9494 E0 14                 CPX   #20                      ;Stop at 'X'=20
1156 9496 90 F2                 BCC   @4                       ;Loop til done
1157 9498
1158 9498 A2 1A                 LDX   #PRPOSITION+3            ;Horizontal position
1159 949A A0 07                 LDY   #CLKPOSITION+2           ;Vertical position
1160 949C 20 BD 93              JSR   FIXVTAB                  ;
1161 949F A2 00                 LDX   #DATE-CASCIITIME         ;Move first byte on first
1162 94A1              @6       EQU   *
1163 94A1 BF 6F 00 00           LDA   >CASCIITIME,X            ;
1164 94A5 DA                    PHX                            ;Preserve 'X' index
1165 94A6 20 D1 A9              JSR   COUTFF                   ;Print character to screen
1166 94A9 FA                    PLX                            ;Recall 'X'
1167 94AA E8                    INX                            ;Decrement counter
1168 94AB E0 08                 CPX   #8                       ;Stop at 'X'=8
1169 94AD 90 F2                 BCC   @6                       ;
1170 94AF
1171 94AF 28                    PLP                            ;Restore interrupt status
1172 94B0 A0 08                 LDY   #CLKPOSITION+3           ;Vertical position
1173 94B2 A9 17                 LDA   #BOTTOMBOX               ;Bottom of box
1174 94B4 4C CF 93              JMP   PRTMSGXPR                ;Do it to it
1175 94B7
1176 94B7
1177 94B7              FILLDBLBAR EQU   *
1178 94B7 A9 5C                 LDA   #DOUBLEBAR               ;Fill character is double bar
1179 94B9 80 0F                 BRA   FILLREST1                ;
1180 94BB
1181 94BB              FILLTOPLINE EQU   *
1182 94BB A9 4C                 LDA   #TOPLINE                 ;Fill character is top line
1183 94BD 80 12                 BRA   FILLREST3                ;
1184 94BF
1185 94BF              FILLINVSPACE EQU   *
1186 94BF A9 20                 LDA   #INVSPACE                ;Fill character is inverse space
1187 94C1 80 07                 BRA   FILLREST1                ;
1188 94C3
1189 94C3              FILLSPACE EQU   *
1190 94C3 A9 A0                 LDA   #SPACE                   ;Fill character is space
1191 94C5 80 0A                 BRA   FILLREST3                ;No right line wanted here
1192 94C7
1193 94C7              FILLREST EQU   *                        ;Fill rest of line with character in 'A'
1194 94C7 48                    PHA                            ;Preserve fill character
1195 94C8 80 03                 BRA   FILLREST2                ;Skip RIGHTLINE stuff
1196 94CA
1197 94CA              FILLREST1 EQU   *                       ;Fill rest of line with character in 'A'
1198 94CA 48                    PHA                            ;Preserve fill character
1199 94CB A9 5A                 LDA   #RIGHTLINE               ;Right line character needed
1200 94CD
1201 94CD              FILLREST2 EQU   *
1202 94CD 20 D1 A9              JSR   COUTFF                   ;
1203 94D0 68                    PLA                            ;Restore fill character
1204 94D1
1205 94D1              FILLREST3 EQU   *
1206 94D1 48                    PHA                            ;Preserve fill character
1207 94D2 A5 24                 LDA   CH                       ;Assume 40 column display
1208 94D4 2C 1F C0              BIT   RD80VID                  ;If in 80 columns get CH from OURGH
1209 94D7 10 06                 BPL   @5                       ;'+' use CH
1210 94D9 AD 7B 05              LDA   OURCH                    ;'-' user OURCH (80 column CH)
1211 94DC 38                    SEC                            ;Prepare to subtract
1212 94DD E9 14                 SBC   #20                      ;Subtract 80 column offset
1213 94DF              @5       EQU   *
1214 94DF AA                    TAX                            ;'X' contains counter
1215 94E0 68                    PLA                            ;Restore fill character
1216 94E1
1217 94E1              @7       EQU   *
1218 94E1 E0 27                 CPX   #39                      ;Stop on CV = 39
1219 94E3 B0 25                 BCS   FILLREST8                ;Exit if here
1220 94E5 DA                    PHX                            ;Save horizontal index
1221 94E6 48                    PHA                            ;Save fill character
1222 94E7 20 D1 A9              JSR   COUTFF                   ;
1223 94EA 68                    PLA                            ;
1224 94EB FA                    PLX                            ;
1225 94EC E8                    INX                            ;Increment to next horizontal position
1226 94ED 80 F2                 BRA   @7                       ;Loop til done
1227 94EF
1228 94EF
1229 94EF              * PRINTRAM determines what RAM value should
1230 94EF              * be converted from Hex to Decimal and prints it
1231 94EF              * on the RAMDISK screen.
1232 94EF
1233 94EF              PRINTRAM EQU   *                        ;Print RAM value for RAMDISK screen
1234 94EF 20 8C 99              JSR   GETUSROPT                ;'A' contains low byte
1235 94F2 A8                    TAY                            ; and save as index for later.
1236 94F3 8A                    TXA                            ;On first line
1237 94F4 F0 27                 BEQ   PRINTRAM0                ;Do it
1238 94F6
1239 94F6 C2 20                 REP   #$20                     ;16 bit 'm' required here
1240 94F8 E0 01                 CPX   #RAMDSKLN3-RAMDSKLN1     ;On 3rd line of RAMDISK screen?
1241 94FA F0 0F                 BEQ   PRINTRM2                 ;= then on line 3
1242 94FC E0 04                 CPX   #RAMDSKLN5-RAMDSKLN1     ;On 5th line?
1243 94FE F0 0F                 BEQ   PRINTRM4                 ;= then on line 5
1244 9500 E0 05                 CPX   #RAMDSKLN6-RAMDSKLN1     ;On 6th (last) line?
1245 9502 F0 0F                 BEQ   PRINTRM6                 ;= then on line 6
1246 9504 E0 06                 CPX   #RAMDSKLN7-RAMDSKLN1     ;On 7th (last) line?
1247 9506 F0 0F                 BEQ   PRINTRM8                 ;= then on line 7
1248 9508 E2 30                 SEP   #$30                     ;Exit in 8 bit land
1249 950A
1250 950A              FILLREST8 EQU   *
1251 950A 60                    RTS                            ;If here then on '  ' line
1252 950B
1253 950B
1254 950B              PRINTRM2 EQU   *
1255 950B A5 59                 LDA   FREERAM+1                ;Free RAM for Ramdisk
1256 950D 80 0A                 BRA   PRINTRM9                 ;
1257 950F
1258 950F              PRINTRM4 EQU   *
1259 950F A5 5D                 LDA   CURRENTRAM+1             ;Current Ramdisk Size
1260 9511 80 06                 BRA   PRINTRM9                 ;
1261 9513
1262 9513              PRINTRM6 EQU   *
1263 9513 A5 61                 LDA   PROGRAMRAM+1             ;RAM Used for Program
1264 9515 80 02                 BRA   PRINTRM9                 ;
1265 9517
1266 9517              PRINTRM8 EQU   *
1267 9517 A5 55                 LDA   TOTALFRAM+1              ;Total RAM in use
1268 9519              PRINTRM9 EQU   *
1269 9519 4A                    LSR   A                        ;Divide by 2 ten times this way
1270 951A 4A                    LSR   A                        ;
1271 951B 80 2A                 BRA   PRINTRAM1_8              ;
1272 951D
1273 951D              PRINTRAM0 EQU   *                       ;First line of screen
1274 951D C2 20                 REP   #$20                     ;Must do in 16 bit mode
1275 951F                       LONGA ON
1276 951F A9 00 80              LDA   #$8000                   ;32768 (32K) increments used
1277 9522                       LONGA OFF
1278 9522 85 1B                 STA   SHIFTER                  ;Save in counter
1279 9524 64 1D                 STZ   SHIFTER+2                ;Zero out hi bytes
1280 9526
1281 9526 F4 00 00              PEA   $0000                    ;Make room for sum on stack
1282 9529 F4 00 00              PEA   $0000                    ;
1283 952C 18                    CLC                            ;Clear carry for 1st add
1284 952D              @1       EQU   *
1285 952D 88                    DEY                            ;Decrement addition counter
1286 952E C0 FF                 CPY   #$FF                     ;Decremented below $00 then done
1287 9530 F0 10                 BEQ   @1_2                     ;'-' then use $0000 as value
1288 9532 A3 01                 LDA   1,S                      ;Summing value
1289 9534 65 1B                 ADC   SHIFTER                  ;Add 32K to sum
1290 9536 83 01                 STA   1,S                      ;Resave on stack
1291 9538 A3 03                 LDA   3,S                      ;
1292 953A 65 1D                 ADC   SHIFTER+2                ;
1293 953C 83 03                 STA   3,S                      ;Resave on stack
1294 953E 63 01                 ADC   1,S                      ;Else add 32k to sum
1295 9540 80 EB                 BRA   @1                       ;Loop always
1296 9542
1297 9542              @1_2     EQU   *
1298 9542 FA                    PLX                            ;Remove a byte from stack
1299 9543 68                    PLA                            ;Result to show to user
1300 9544 4A                    LSR   A                        ;Converted to 'K'ilobytes
1301 9545 4A                    LSR   A                        ;
1302 9546 FA                    PLX                            ;Remove last excess byte from stack
1303 9547
1304 9547              PRINTRAM1_8 EQU   *
1305 9547 E2 30                 SEP   #$30                     ;Back to 8 bit land
1306 9549 EB                    XBA                            ;Hi nybble to low nybble
1307 954A AA                    TAX                            ;Put hi byte in 'X' for printing
1308 954B EB                    XBA                            ;Lo byte in 'A' for printing
1309 954C 18                    CLC                            ;'c'= 0 to right justify
1310 954D
1311 954D
1312 954D              * Convert hex value to decimal and display
1313 954D              * it on the screen at the current CV/CH position.
1314 954D              *
1315 954D              * Hex number to convert to decimal ASCII
1316 954D              * is transmitted to this subroutine in 'A' and 'X'.
1317 954D              *       'A'=lo byte      'X'=Hi byte
1318 954D              *
1319 954D              *       'c'=0 to right justify decimal ASCII
1320 954D              *       'c'=1 to left justify decimal ASCII
1321 954D              *
1322 954D
1323 954D              MKDECASC EQU   *
1324 954D 85 3E                 STA   A2L                      ;Lo byte into A2L
1325 954F 86 3F                 STX   A2H                      ;Hi byte into A2H
1326 9551 66 34                 ROR   YSAV                     ;'+'/'-'=rt/lft justify decimal ASCII
1327 9553 A0 05                 LDY   #$05                     ;Number of times in loop
1328 9555              @1       EQU   *
1329 9555 A2 11                 LDX   #16+1                    ;16 bits and 1st time do nothing
1330 9557 A9 00                 LDA   #$00                     ;
1331 9559 18                    CLC                            ;C=0 so first ROL leaves A=0
1332 955A 2A           @2       ROL   A                        ;
1333 955B C9 0A                 CMP   #10                      ;A >= 10?
1334 955D 90 02                 BCC   @4                       ;Branch if <
1335 955F E9 0A                 SBC   #10                      ;C=1 frm CMP and is left set
1336 9561 26 3E        @4       ROL   A2L                      ;
1337 9563 26 3F                 ROL   A2H                      ;
1338 9565 CA                    DEX                            ;
1339 9566 D0 F2                 BNE   @2                       ;
1340 9568 09 B0                 ORA   #$B0                     ;Make an ascii char
1341 956A 48                    PHA                            ;Preserve data on stack
1342 956B 88                    DEY                            ;
1343 956C D0 E7                 BNE   @1                       ;
1344 956E
1345 956E A0 04                 LDY   #$04                     ;Maximum number of bytes to print-1
1346 9570              @6       EQU   *
1347 9570 68                    PLA                            ;Recall byte to print
1348 9571 C9 B0                 CMP   #$B0                     ;'0' then don't print it
1349 9573 D0 15                 BNE   @9                       ;
1350 9575 24 34                 BIT   YSAV                     ;- then left justify else right justify
1351 9577 30 0A                 BMI   @7                       ;For left justification only
1352 9579 BB                    TYX                            ;Test for 'Y'=0
1353 957A F0 0A                 BEQ   @7_4                     ;If 'Y'=0 then do NOT print a ' '
1354 957C 5A                    PHY                            ;Preserve 'Y'
1355 957D 48                    PHA                            ;Preserve character to print
1356 957E 20 91 AC              JSR   PR1BLNKFF                ;Put a space on screen
1357 9581 68                    PLA                            ;Recall character to print
1358 9582 7A                    PLY                            ;Recall 'Y'
1359 9583              @7       EQU   *
1360 9583 88                    DEY                            ;Decrement counter
1361 9584 10 EA                 BPL   @6                       ;Don't print preceeding '0's
1362 9586
1363 9586              @7_4     EQU   *
1364 9586 4C D1 A9              JMP   COUTFF                   ;Print only '0'
1365 9589
1366 9589              @8       EQU   *
1367 9589 68                    PLA                            ;Recall converted value to print
1368 958A              @9       EQU   *
1369 958A 5A                    PHY                            ;
1370 958B 20 D1 A9              JSR   COUTFF                   ;Print value
1371 958E 7A                    PLY                            ;Recall registers
1372 958F 88                    DEY                            ;
1373 9590 10 F7                 BPL   @8                       ;
1374 9592 60                    RTS                            ;Return to caller
1375 9593
1376 9593
1377 9593              * If Port 1 / Port 2 are all selected for 
1378 9593              * AppleTalk at the same time this routine
1379 9593              * displeys a prompt on the Printer or Modem    
1380 9593              * Port screen.
1381 9593              *
1382 9593              * If they are not all active, this routine
1383 9593              * erases the part of the screen where the
1384 9593              * prompt would normally appear.
1385 9593
1386 9593              WARNPROMPT EQU   *
1387 9593 A5 00                 LDA   CURSCRN                  ;Which screen we on?
1388 9595 C9 06                 CMP   #CPLN7-CPLN1             ;If Printer Port screen do some stuff
1389 9597 D0 14                 BNE   @1                       ;BRA if not
1390 9599 A9 00                 LDA   #$00                     ;Zero out serial port1 indicator flag
1391 959B 8F 43 01 E1           STA   >C1FLAG                  ;
1392 959F 20 A8 98              JSR   GETSTATNUM               ;Set up submenu information
1393 95A2 AF C0 02 E1           LDA   >USERPORT1               ;If =2 then AppleTalk selected
1394 95A6 C9 02                 CMP   #$02                     ;
1395 95A8 D0 74                 BNE   NOSHRINK                 ;BRA if not
1396 95AA 20 20 96              JSR   CHPORTMENU               ;Shrink the display for ApTalk 
1397 95AD
1398 95AD              @1       EQU   *
1399 95AD C9 07                 CMP   #CPLN8-CPLN1             ;Else check for Modem Port screen
1400 95AF D0 14                 BNE   @3                       ;BRA to check for two ApTalk
1401 95B1 A9 00                 LDA   #$00                     ;Zero out serial port2 indicatior flag
1402 95B3 8F 44 01 E1           STA   >C2FLAG                  ;
1403 95B7 20 A8 98              JSR   GETSTATNUM               ;
1404 95BA AF CC 02 E1           LDA   >USERPORT2               ;
1405 95BE C9 02                 CMP   #$02                     ;Port1 already ApTalk, chk port2
1406 95C0 D0 5C                 BNE   NOSHRINK                 ;Bra if not AppleTalk selected
1407 95C2 20 20 96              JSR   CHPORTMENU               ;Shrink the display for$ApTalk
1408 95C5
1409 95C5              @3       EQU   *
1410 95C5
1411 95C5 A5 00                 LDA   CURSCRN                  ;Get current screen again
1412 95C7 C9 05                 CMP   #CPLN6-CPLN1             ;Check for slot screen
1413 95C9 D0 42                 BNE   NOT2APTALK               ;BRA to end if not slot screen
1414 95CB AF E1 02 E1           LDA   >USERSLT1                ;Get slot1 assignmnet, 2=AppleTalk
1415 95CF C9 02                 CMP   #$02                     ;Is it assigned for AppleTalk ?
1416 95D1 D0 0C                 BNE   @4                       ;BRA if not
1417 95D3 4F E2 02 E1           EOR   >USERSLT2                ;Check with slot2 assignment
1418 95D7 D0 06                 BNE   @4                       ;<>0 then all's fine
1419 95D9 A9 1A                 LDA   #TWOAPTALK               ;Message number
1420 95DB A0 10                 LDY   #WPOSITION               ;Vertical position
1421 95DD 80 27                 BRA   @5                       ;Display warning message
1422 95DF              @4       EQU   *
1423 95DF AF E7 02 E1           LDA   >USERSLT7                ;CHK slot7 configuration
1424 95E3 F0 08                 BEQ   @6                       ;BRA if slot7=ApTalk
1425 95E5 AF E8 02 E1           LDA   >USERSLTST               ;CHK 'StartUp' selection
1426 95E9 C9 0A                 CMP   #$0A                     ;Is it set to boot from ApTalk
1427 95EB D0 20                 BNE   NOT2APTALK               ;BRA if all is fine
1428 95ED              @6       EQU   *
1429 95ED A9 02                 LDA   #$02                     ;If slot7=ApTalk, then chk slot1/slot2
1430 95EF CF E1 02 E1           CMP   >USERSLT1                ; either slot1 or slot2 needs to be 
1431 95F3 F0 18                 BEQ   NOT2APTALK               ; set to AppleTalk
1432 95F5 CF E2 02 E1           CMP   >USERSLT2                ;If slot1 not ApTalk, chk slot2
1433 95F9 F0 12                 BEQ   NOT2APTALK               ;BRA if all's fine
1434 95FB A9 18                 LDA   #APS1S2L1                ;Message number
1435 95FD A0 10                 LDY   #WPOSITION               ;Vertical position
1436 95FF 20 06 96              JSR   @5                       ;Print error message
1437 9602 A9 19                 LDA   #APS1S2L2                ;Message number
1438 9604 A0 11                 LDY   #WPOSITION+1             ;Vertical position
1439 9606              @5       EQU   *
1440 9606 A2 01                 LDX   #$01                     ;Vertical position
1441 9608 20 D1 93              JSR   PRINTMSGXY               ;Display warning message
1442 960B 38                    SEC                            ;'C' = 1 on bad exit
1443 960C 60                    RTS                            ;Back to caller with prompt on screen
1444 960D
1445 960D              NOT2APTALK EQU   *
1446 960D              NOTALLON EQU   *
1447 960D A0 10                 LDY   #WPOSITION               ;Vertical position
1448 960F 20 14 96              JSR   @1                       ;Space out rest of line
1449 9612 A0 11                 LDY   #WPOSITION+1             ;Continue to clean next line
1450 9614              @1       EQU   *
1451 9614 A2 01                 LDX   #$01                     ;Horizontal position
1452 9616 20 BD 93              JSR   FIXVTAB
1453 9619 A9 A0                 LDA   #SPACE
1454 961B 20 C7 94              JSR   FILLREST                 ;Space out rest of line
1455 961E              NOSHRINK EQU   *
1456 961E 18                    CLC                            ;'C'=0 if ok      
1457 961F 60                    RTS                            ;Back to caller
1458 9620
1459 9620              CHPORTMENU EQU   *
1460 9620 A0 0A                 LDY   #$0A                     ;
1461 9622 20 95 98              JSR   CLRTOBTM                 ;
1462 9625 20 06 94              JSR   PRINTBORDER              ;
1463 9628 60                    RTS   
1464 9629
1465 9629
1466 9629              CENTERALINE EQU   *
1467 9629 A9 53                 LDA   #CENTERLINE              ;Print a centerline mouse text character
1468 962B 4C D1 A9              JMP   COUTFF                   ;
1469 962E
1470 962E
1471 962E              ALLBORDER EQU   *
1472 962E A2 01                 LDX   #CPHPOSITION             ;Horizontal position of start of border
1473 9630 A0 00                 LDY   #CPVPOSITION-1           ;Vertical position of start of border
1474 9632 20 BD 93              JSR   FIXVTAB                  ;Move to position
1475 9635 A9 DF                 LDA   #BOTTOMLINE              ;Output 1 char to set OURCH if in 80 cols
1476 9637 20 C7 94              JSR   FILLREST                 ;Put in underline stuff
1477 963A 20 E6 93              JSR   PRINTEDGES               ;Put up edges
1478 963D 4C 46 94              JMP   ADDBOTTOM                ;Put up bottom of screen
1479 9640
1480 9640
1481 9640              UNDERTITLE EQU   *                      ;Fill title line and underline it
1482 9640 20 BF 94              JSR   FILLINVSPACE             ;Fill rest of line with inverse space
1483 9643
1484 9643              * Put line under main title
1485 9643
1486 9643 A2 01                 LDX   #CPHPOSITION             ;Horizontal position
1487 9645 A0 02                 LDY   #CPVPOSITION+1           ;Vertical position
1488 9647 20 BD 93              JSR   FIXVTAB                  ;Move to position
1489 964A A9 4C                 LDA   #TOPLINE                 ;Output 1 char to set OURCH if in 80 cols
1490 964C 4C C7 94              JMP   FILLREST                 ;Put in top line stuff
1491 964F
1492 964F
1493 964F
1494 964F                       TITLE 'Print Sub Menu Screens'
1495 964F
1496 964F              ******************************************************
1497 964F              *                                                    *
1498 964F              *  Print Sub Menus for Control Panel Desk Accessory  *
1499 964F              *                                                    *
1500 964F              *                    by                              *
1501 964F              *               Fern Bachman     1985-1987           *
1502 964F              *               Joe Bo           1987-1989           *
1503 964F              *                                                    *
1504 964F              *       Copyright Apple Computer, Inc. 1985-1989     *
1505 964F              *                All Rights Reserved.                *
1506 964F              *                                                    *
1507 964F              ******************************************************
1508 964F
1509 964F
1510 964F              PDISPSBM EQU   *                        ;Show display screen
1511 964F 4C 18 97              JMP   DISPSBM                  ;
1512 9652
1513 9652              PRSTCLOCKSBM EQU   *                    ;Show clock screen
1514 9652 4C FB 97              JMP   RSTCLOCKSBM              ;
1515 9655
1516 9655              PRAMDSKSBM EQU   *                      ;Show ramdisk screen
1517 9655 4C A3 97              JMP   RAMDSKSBM                ;
1518 9658
1519 9658
1520 9658              PRINTSBMENU EQU   *                     ;Print < >'s and submenu
1521 9658 A0 05                 LDY   #SPOSITION               ;Vertical position for 1st line
1522 965A 84 25                 STY   CV                       ;Save to use later
1523 965C A6 00                 LDX   CURSCRN                  ;Which screen do we display now?
1524 965E F0 EF                 BEQ   PDISPSBM                 ;Show display screen
1525 9660 E0 03                 CPX   #CPLN4-CPLN1             ;Is it clock screen?
1526 9662 F0 EE                 BEQ   PRSTCLOCKSBM             ;Show clock screen
1527 9664 E0 08                 CPX   #CPLN9-CPLN1             ;Is it ramdisk screen?
1528 9666 F0 ED                 BEQ   PRAMDSKSBM               ;Show ramdisk screen
1529 9668 20 81 99              JSR   GET1STLNUM               ;Get 1st line message number
1530 966B
1531 966B              * Print a complete submenu screen
1532 966B
1533 966B A2 00                 LDX   #$00                     ;Counter
1534 966D              @12      EQU   *
1535 966D 20 80 96              JSR   PRINTLINE                ;Print an appropriate line
1536 9670 34 83                 BIT   REALLNTBL,X              ;'n'=1 then don't print options
1537 9672 30 03                 BMI   @13                      ;
1538 9674 20 B5 96              JSR   PRINTOPTION              ;Print options
1539 9677              @13      EQU   *
1540 9677 E6 25                 INC   CV                       ;Prepare for the next line
1541 9679 1A                    INC   A                        ;Increment message number of line
1542 967A E8                    INX                            ;Increment counter
1543 967B E4 04                 CPX   NUMLINES                 ; and test to see if done.
1544 967D 90 EE                 BCC   @12                      ;Loop til done
1545 967F 60                    RTS                            ;Back to caller
1546 9680
1547 9680
1548 9680              * Print a line up to and including ':'.
1549 9680              * 'A' and 'X' registers are preserved.
1550 9680
1551 9680              PRINTLINE EQU   *
1552 9680 48                    PHA                            ;Preserve 'A' and 'X'
1553 9681 DA                    PHX                            ;
1554 9682 B5 83                 LDA   REALLNTBL,X              ;'-' then message delimiter line only
1555 9684 08                    PHP                            ;Save status for later
1556 9685 A3 02                 LDA   2,S                      ;Recall line number we are on
1557 9687 C5 02                 CMP   NEWLINE                  ;If 'X' = NEWLINE then inverse
1558 9689 D0 03                 BNE   @4                       ;<>= then print normally
1559 968B 20 20 9A              JSR   TURNOFFMTXT              ;Disable mouse text + enable inverse
1560 968E              @4       EQU   *
1561 968E 18                    CLC                            ;Clear carry to ADC to follow
1562 968F A9 05                 LDA   #SPOSITION               ;Calculate where line goes
1563 9691 63 02                 ADC   2,S                      ;Add line number
1564 9693 A8                    TAY                            ;Put in 'Y' for PRINTMSGXY
1565 9694 A2 04                 LDX   #LNPOSITION              ;Horizontal position for lines
1566 9696 A3 03                 LDA   3,S                      ;Message number
1567 9698 20 D1 93              JSR   PRINTMSGXY               ;Go print it
1568 969B 28                    PLP                            ;Do ': ' or not?
1569 969C 08                    PHP                            ;Place holder on stack
1570 969D 30 12                 BMI   @6                       ;'-' then no ': '
1571 969F A9 BA                 LDA   #':'                     ;Colon first
1572 96A1 20 D1 A9              JSR   COUTFF                   ;
1573 96A4 20 11 9A              JSR   TURNONMTXT               ;Always enable mouse text chars here
1574 96A7 20 91 AC              JSR   PR1BLNKFF                ;Print a space
1575 96AA A3 02                 LDA   2,S                      ;Recall line number to act on
1576 96AC 85 01                 STA   CURLINE                  ;Save as current line
1577 96AE 20 4B 99              JSR   SETUPLNSTUF              ;Set up zero page stuff for PRINTLINE
1578 96B1
1579 96B1              @6       EQU   *
1580 96B1 28                    PLP                            ;Clear 1 byte off stack
1581 96B2 FA                    PLX                            ;Restore 'X'
1582 96B3 68                    PLA                            ;Restore 'A'
1583 96B4 60                    RTS                            ;Back to caller
1584 96B5
1585 96B5
1586 96B5              * Print option prints the option corresponding
1587 96B5              * to the value in CURLINE.  SETUPLNSTUFF must be
1588 96B5              * called prior to calling PRINTOPTION.
1589 96B5              *
1590 96B5              * 'A' and 'X' registers are preserved.
1591 96B5
1592 96B5              PRINTOPTION EQU   *
1593 96B5 48                    PHA                            ;Preserve 'A'
1594 96B6 DA                    PHX                            ;Preserve 'X'
1595 96B7 A6 01                 LDX   CURLINE                  ;Current line user is on
1596 96B9 B4 93                 LDY   REALOPTTBL,X             ;Get real offset into tables
1597 96BB B7 AD                 LDA   [BRAMPTR],Y              ;Add user option as offset to 1st msg num
1598 96BD
1599 96BD A6 00                 LDX   CURSCRN                  ;Are we on language screen?
1600 96BF E0 04                 CPX   #CPLN5-CPLN1             ;
1601 96C1 D0 13                 BNE   @7                       ;If not, continue on      
1602 96C3 BB                    TYX                            ;Set/reset 'z' flag
1603 96C4 F0 0B                 BEQ   @6                       ;
1604 96C6 C0 02                 CPY   #$02                     ;2 or > then do normally
1605 96C8
1606 96C8 B0 0C                 BCS   @7                       ;Continue on normally
1607 96CA
1608 96CA AA                    TAX                            ;Transfer to 'X' index
1609 96CB BF 08 03 E1           LDA   >LAYOUTS+1,X             ;Get option number offset to display
1610 96CF 80 05                 BRA   @7                       ;
1611 96D1
1612 96D1              *
1613 96D1              @6       EQU   *
1614 96D1 AA                    TAX                            ;Transfer to 'X' index
1615 96D2 BF FF 02 E1           LDA   >LANGS+1,X               ;Get option number offset to display
1616 96D6              @7       EQU   *
1617 96D6 18                    CLC                            ;
1618 96D7 77 A4                 ADC   [OPTPTR],Y               ;
1619 96D9
1620 96D9 A6 00                 LDX   CURSCRN                  ;Are we on slots screen ?
1621 96DB E0 05                 CPX   #CPLN6-CPLN1
1622 96DD D0 0C                 BNE   GOPRINT                  ;If not slot screen, then print option msg w/ 8-bit print 
1623 96DF
1624 96DF 48                    PHA                            ;Temp save low 'A', adjust for slot option msg to be 16-bit prt
1625 96E0 A9 01                 LDA   #$01                     ;Set high 'A' to 1, the slots 'DS' table must start at page 1
1626 96E2 EB                    XBA                            ;exchange high/low
1627 96E3 68                    PLA                            ;Restore low byte 'A'
1628 96E4 C2 30                 REP   #$30                     ;Off to 16-bit printing
1629 96E6 20 85 C0              JSR   PRINTMSG2                ;Execute the 16-bit printing, return w/ 8-bit
1630 96E9 80 03                 BRA   COMMON                   ;Continue w/ common stuff handling
1631 96EB
1632 96EB              GOPRINT  EQU   *
1633 96EB 20 80 C0              JSR   PRINTMSG                 ;Print message
1634 96EE
1635 96EE              * Test if same as default option
1636 96EE
1637 96EE              COMMON   EQU   *
1638 96EE A6 01                 LDX   CURLINE                  ;Current line user is on
1639 96F0 B4 93                 LDY   REALOPTTBL,X             ;Get real offset into tables
1640 96F2
1641 96F2              PRINTOPT2 EQU   *
1642 96F2 20 C3 94              JSR   FILLSPACE                ;Blank out rest of line and exit
1643 96F5 20 FB 96              JSR   PRINTOPTDEF              ;Print opt / default indicator if needed
1644 96F8 FA                    PLX                            ;Restore 'X'
1645 96F9 68                    PLA                            ;Restore 'A'
1646 96FA 60                    RTS                            ;Back to caller
1647 96FB
1648 96FB              PRINTOPTDEF EQU   *
1649 96FB B7 AD                 LDA   [BRAMPTR],Y              ;Current selection
1650 96FD D7 AA                 CMP   [DEFAULTPTR],Y           ;Default selection
1651 96FF              PRINTOPTDEF2 EQU   *
1652 96FF 08                    PHP                            ;Save 'z' status
1653 9700 A2 02                 LDX   #DEFPOSITION             ;Default indicator position
1654 9702 A4 25                 LDY   CV                       ;
1655 9704 20 BD 93              JSR   FIXVTAB                  ;Move to position
1656 9707 28                    PLP                            ;Recall 'z' status
1657 9708 D0 09                 BNE   @1                       ;<>= then its not default
1658 970A 20 44 9A              JSR   PRTMODEM                 ;CHK for 1st line prt/modem scrn
1659 970D F0 04                 BEQ   @1                       ;Skip default indicator if it is
1660 970F A9 44                 LDA   #DINDICATOR              ;Print default indicator.
1661 9711 80 02                 BRA   @2                       ;Continue on
1662 9713              @1       EQU   *
1663 9713 A9 A0                 LDA   #SPACE                   ;Anticipate remove def indicator from scrn
1664 9715 4C D1 A9     @2       JMP   COUTFF                   ;
1665 9718
1666 9718
1667 9718              DISPSBM  EQU   *                        ;Show display screen
1668 9718 20 81 99              JSR   GET1STLNUM               ;Get 1st line message number
1669 971B A2 00                 LDX   #$00                     ;Start with 1st line of screen
1670 971D              @22      EQU   *
1671 971D 20 80 96              JSR   PRINTLINE                ;Print option line
1672 9720 48                    PHA                            ;Preserve 'A'
1673 9721 DA                    PHX                            ;Preserve 'X'
1674 9722 E0 08                 CPX   #DISPLN9-DISPLN1         ;
1675 9724 D0 14                 BNE   @2_7                     ;<>= then handle normally
1676 9726 AF DD 02 E1           LDA   >USERHERTZ               ;0=60 hertz 1=50 hertz
1677 972A D0 04                 BNE   @1                       ;
1678 972C A9 A6                 LDA   #DISPOP4_0               ;60 hertz message number
1679 972E 80 02                 BRA   @2                       ;
1680 9730
1681 9730              @1       EQU   *
1682 9730 A9 78                 LDA   #PORTOP7_0               ;50 hertz message number
1683 9732              @2       EQU   *
1684 9732 20 80 C0              JSR   PRINTMSG                 ;Print message and restore 'X' and 'A'
1685 9735 20 29 96              JSR   CENTERALINE              ;Put up centerline
1686 9738 80 49                 BRA   @3                       ;Continue this way
1687 973A
1688 973A              @2_7     EQU   *
1689 973A FA                    PLX                            ;Restore 'X'
1690 973B 68                    PLA                            ;Restore 'A'
1691 973C 34 83                 BIT   REALLNTBL,X              ;'n'=1 then don't print options
1692 973E 30 45                 BMI   @4                       ;
1693 9740 48                    PHA                            ;Save 'A'
1694 9741 DA                    PHX                            ;Save 'X'
1695 9742 B5 83                 LDA   REALLNTBL,X              ;What's real line number?
1696 9744 C9 06                 CMP   #DISPLN7-DISPLN1         ;If on 'Standards' line show 'Yes/No'
1697 9746 D0 30                 BNE   @2_75                    ;
1698 9748
1699 9748              * Now test if standard values being shown.
1700 9748              * If not put up 'No', if so put up 'Yes'.
1701 9748
1702 9748 A2 03                 LDX   #DISPLN4-DISPLN1         ;'Text' option index
1703 974A 20 8C 99              JSR   GETUSROPT                ;Get user's choice
1704 974D D7 AA                 CMP   [DEFAULTPTR],Y           ;Test against default value
1705 974F D0 18                 BNE   @123                     ;<>= then not default color
1706 9751 A2 04                 LDX   #DISPLN5-DISPLN1         ;'Background' option index
1707 9753 20 8C 99              JSR   GETUSROPT                ;
1708 9756 D7 AA                 CMP   [DEFAULTPTR],Y           ;
1709 9758 D0 0F                 BNE   @123                     ;<>= then not default color
1710 975A A2 05                 LDX   #DISPLN6-DISPLN1         ;'Border' option index
1711 975C 20 8C 99              JSR   GETUSROPT                ;Get user's ghoice
1712 975F D7 AA                 CMP   [DEFAULTPTR],Y           ;Test against default value
1713 9761 D0 06                 BNE   @123                     ;<>= then not default colors
1714 9763 A9 77                 LDA   #LANGOP3_0+1             ;'Yes' message number
1715 9765 E2 02                 SEP   #$02                     ;Set 'z' flag
1716 9767 80 02                 BRA   @9                       ;Print message
1717 9769
1718 9769              @123     EQU   *                        ;Not default colors
1719 9769 A9 76                 LDA   #LANGOP3_0               ;'No' message number
1720 976B              @9       EQU   *
1721 976B 08                    PHP                            ;Preserve 'z' status
1722 976C 20 80 C0              JSR   PRINTMSG                 ;Print message
1723 976F 20 91 AC              JSR   PR1BLNKFF                ;Print a space
1724 9772 28                    PLP                            ;Restore 'z' status
1725 9773 20 FF 96              JSR   PRINTOPTDEF2             ;Show/erase default indicator
1726 9776 80 0B                 BRA   @3                       ;Continue this way
1727 9778
1728 9778
1729 9778              @2_75    EQU   *
1730 9778 C9 02                 CMP   #DISPLN3-DISPLN1         ;=>3rd line then no options to display
1731 977A 90 04                 BCC   @2_9                     ;
1732 977C C9 06                 CMP   #DISPLN7-DISPLN1         ;'Border'
1733 977E B0 03                 BCS   @3                       ;
1734 9780
1735 9780              @2_9     EQU   *
1736 9780 20 B5 96              JSR   PRINTOPTION              ;Print option normally
1737 9783              @3       EQU   *
1738 9783 FA                    PLX                            ;Restore 'X'
1739 9784 68                    PLA                            ;Restore 'A'
1740 9785              @4       EQU   *
1741 9785 E6 25                 INC   CV                       ;Print next line on next vertical line
1742 9787 1A                    INC   A                        ;Next line number message
1743 9788 E8                    INX                            ;
1744 9789 E4 04                 CPX   NUMLINES                 ;Print all screen lines
1745 978B 90 90                 BCC   @22                      ;Loop til 3 lines done
1746 978D
1747 978D
1748 978D 4C 0E BC              JMP   SETCOLORS                ;Setup color/hertz stuff
1749 9790
1750 9790
1751 9790              PRTOPENAPP EQU   *                      ;Print with 'open-apple'
1752 9790 DA                    PHX                            ;Temp save
1753 9791 A9 41                 LDA   #$41                     ;Open-Apple mouse text
1754 9793 20 D1 A9              JSR   COUTFF                   ;Print it
1755 9796 FA                    PLX                            ;Get back index
1756 9797 CA                    DEX   
1757 9798 10 F6                 BPL   PRTOPENAPP
1758 979A A5 00                 LDA   CURSCRN                  ;CHK for valid password screen
1759 979C 30 04                 BMI   @1
1760 979E 28                    PLP                            ;Get back 'z' flag
1761 979F 4C FF 96              JMP   PRINTOPTDEF2             ;Print and exit
1762 97A2 60           @1       RTS   
1763 97A3
1764 97A3
1765 97A3              * Show ramdisk screen
1766 97A3
1767 97A3              RAMDSKSBM EQU   *                       ;Show ramdisk screen
1768 97A3 A0 05                 LDY   #SPOSITION               ;Vertical position for 1st line
1769 97A5 84 25                 STY   CV                       ;Save to use later
1770 97A7 20 81 99              JSR   GET1STLNUM               ;Get 1st line message number
1771 97AA A2 00                 LDX   #$00                     ;Start with 1st line of screen
1772 97AC              @1       EQU   *
1773 97AC DA                    PHX                            ;Preserve 'X'
1774 97AD 48                    PHA                            ;Preserve 'A'
1775 97AE 20 80 96              JSR   PRINTLINE                ;Print line up to ASCII value
1776 97B1 20 EF 94              JSR   PRINTRAM                 ;Print Minimum RAM available for RAMDISK
1777 97B4 A3 02                 LDA   2,S                      ;Test if on '  ' line or 2nd line or not
1778 97B6 C9 02                 CMP   #RAMDSKLN4-RAMDSKLN1     ;If on '  ' line then no 'K'
1779 97B8 F0 1A                 BEQ   @1_4                     ;'=' then skip 'K'
1780 97BA C9 03                 CMP   #RAMDSKLN4_2-RAMDSKLN1   ;'RAM Status' line then no 'K'
1781 97BC F0 16                 BEQ   @1_4                     ;'=' then skip 'K'
1782 97BE C9 07                 CMP   #RAMDSKLN8-RAMDSKLN1     ;If on ' ' line then no 'K'
1783 97C0 F0 12                 BEQ   @1_4                     ;  
1784 97C2 C9 08                 CMP   #RAMDSKLN9-RAMDSKLN1     ;If on 'Re-size..' line then no 'K'
1785 97C4 F0 26                 BEQ   @2_4
1786 97C6 A9 CB                 LDA   #'K'                     ;Kilobytes indicator
1787 97C8 20 D1 A9              JSR   COUTFF                   ;
1788 97CB A3 02                 LDA   2,S                      ;Test if on 'Largest Selectable Size' line
1789 97CD C9 01                 CMP   #RAMDSKLN3-RAMDSKLN1     ;
1790 97CF D0 03                 BNE   @1_4                     ;If not continue normally
1791 97D1 20 29 96              JSR   CENTERALINE              ;If so, then print a centerline
1792 97D4              @1_4     EQU   *
1793 97D4 A3 02                 LDA   2,S                      ;Recover 'X' and 'A'
1794 97D6 AA                    TAX                            ;
1795 97D7 A3 01                 LDA   1,S                      ;
1796 97D9 E0 00                 CPX   #$00                     ;
1797 97DB D0 04                 BNE   @2                       ;
1798 97DD              @1_6     EQU   *
1799 97DD 9B                    TXY                            ;'Y'=line number = 'X'
1800 97DE 20 FB 96              JSR   PRINTOPTDEF              ;Test and maybe print default indicator
1801 97E1              @2       EQU   *
1802 97E1 E6 25                 INC   CV                       ;Next line please
1803 97E3 68                    PLA                            ;Recall 'A'
1804 97E4 1A                    INC   A                        ;Next message number
1805 97E5 FA                    PLX                            ;Recall 'X'
1806 97E6 E8                    INX                            ;Next please
1807 97E7 E4 04                 CPX   NUMLINES                 ;Reached last line yet?
1808 97E9 90 C1                 BCC   @1                       ;
1809 97EB 60                    RTS                            ;Back to caller
1810 97EC
1811 97EC              @2_4     EQU   *
1812 97EC AF F7 02 E1           LDA   >USERXRAM                ;In ramdisk scrn USERRSTRAM=USERXRAM
1813 97F0 D0 04                 BNE   @3                       ;BRA if 'Yes'
1814 97F2 A9 76                 LDA   #RAMDSKOP8_0             ;'No' message number
1815 97F4 80 02                 BRA   @4                       ;Print it
1816 97F6              @3       EQU   *
1817 97F6 A9 77                 LDA   #RAMDSKOP8_0+1           ;'Yes' message number
1818 97F8              @4       EQU   *
1819 97F8 4C EB 96              JMP   GOPRINT                  ;Print it and exit
1820 97FB
1821 97FB              * Show clock screen
1822 97FB
1823 97FB              RSTCLOCKSBM EQU   *                     ;Restart clock submenu here
1824 97FB
1825 97FB              * Set up hour format as AM-PM or 24 hour
1826 97FB
1827 97FB AF F5 02 E1           LDA   >USERAMPM                ;AM/PM / 24 hour format
1828 97FF F0 07                 BEQ   @11                      ;= then AM-PM format
1829 9801 A0 A0                 LDY   #SPACE                   ;' ' ZAMPMASCII for 24 hour time format
1830 9803 BB                    TYX                            ;
1831 9804 A5 68                 LDA   Z24HOUR                  ;Recall 24 hour time
1832 9806 80 17                 BRA   @14                      ;
1833 9808
1834 9808              @11      EQU   *
1835 9808 A2 D0                 LDX   #'P'                     ;Anticipate setting up PM
1836 980A A5 68                 LDA   Z24HOUR                  ;Recall hour count
1837 980C C9 0C                 CMP   #12                      ;>= 12 then PM
1838 980E 90 06                 BCC   @0                       ;< 12 then it's AM
1839 9810 F0 0B                 BEQ   @22                      ;= then it's 12 PM
1840 9812 E9 0C                 SBC   #12                      ;Subtract 12 hour offset ('c' already =1)
1841 9814 80 07                 BRA   @22                      ;
1842 9816
1843 9816              @0       EQU   *
1844 9816 AA                    TAX                            ;Set/clear 'z'
1845 9817 D0 02                 BNE   @1                       ;<>=0 then normal time
1846 9819 A9 0C                 LDA   #12                      ;Convert 0 AM to 12 AM
1847 981B              @1       EQU   *
1848 981B A2 C1                 LDX   #'A'                     ;Set up AM
1849 981D              @22      EQU   *
1850 981D A0 CD                 LDY   #'M'                     ;
1851 981F              @14      EQU   *
1852 981F 86 6D                 STX   ZAMPMASCII               ;
1853 9821 84 6E                 STY   ZAMPMASCII+1             ;
1854 9823 85 6C                 STA   ZHOUR                    ;Save converted hour value
1855 9825
1856 9825 A0 05                 LDY   #SPOSITION               ;Vertical position for 1st line
1857 9827 84 25                 STY   CV                       ;Save to use later
1858 9829 A6 00                 LDX   CURSCRN                  ;Which screen we on?
1859 982B 20 81 99              JSR   GET1STLNUM               ;Get 1st line message number
1860 982E A2 00                 LDX   #$00                     ;Start on 1st clock line
1861 9830              @111     EQU   *                        ;Loop back to here for each line
1862 9830 48                    PHA                            ;Preserve line message number currently on
1863 9831 DA                    PHX                            ;Preserve line number
1864 9832 20 80 96              JSR   PRINTLINE                ;Print a line
1865 9835
1866 9835 20 8C 99              JSR   GETUSROPT                ;Sets 'Y'=corrected scrn line num offset
1867 9838 E0 03                 CPX   #CLOCKLN4-CLOCKLN1       ;Line 4 gets format option
1868 983A F0 31                 BEQ   @2                       ;
1869 983C E0 04                 CPX   #CLOCKLN5-CLOCKLN1       ;Line 5 gets no option
1870 983E F0 37                 BEQ   @6                       ;
1871 9840 E0 08                 CPX   #CLOCKLN9-CLOCKLN1       ;Line 9 gets format option
1872 9842 F0 1F                 BEQ   @4                       ;
1873 9844
1874 9844 A6 01                 LDX   CURLINE                  ;If on hour line then get different value
1875 9846 E0 05                 CPX   #CLOCKLN6-CLOCKLN1       ;
1876 9848 D0 02                 BNE   @1_1                     ;<>= then do normally
1877 984A A0 08                 LDY   #ZHOUR-ZMONTH            ;Change offset
1878 984C              @1_1     EQU   *
1879 984C B9 64 00              LDA   |ZMONTH,Y                ;Get hex value
1880 984F C0 00                 CPY   #CLOCKLN1-CLOCKLN1       ;On 1st line then inc value
1881 9851 F0 04                 BEQ   @1_2                     ;
1882 9853 C0 01                 CPY   #CLOCKLN2-CLOCKLN1       ;On 2nd line then inc value
1883 9855 D0 01                 BNE   @1_4                     ;
1884 9857              @1_2     EQU   *
1885 9857 1A                    INC   A                        ;Increment value
1886 9858              @1_4     EQU   *
1887 9858 A2 00                 LDX   #$00                     ;Hi byte = 0
1888 985A 38                    SEC                            ;Set left justify mode
1889 985B 20 4D 95              JSR   MKDECASC                 ;Convert hex to decimal ASCII and print
1890 985E 20 91 AC              JSR   PR1BLNKFF                ;Print a space just in case
1891 9861 80 14                 BRA   @6                       ;Skip format option stuff
1892 9863
1893 9863              @4       EQU   *
1894 9863 A0 01                 LDY   #$01                     ;$00=user date fmt - $01=user time fmt
1895 9865 20 DF 93              JSR   PRTOPT                   ;Print option message
1896 9868
1897 9868 A0 01                 LDY   #$01                     ;$00=user date fmt - $01=user time fmt
1898 986A 4C F2 96              JMP   PRINTOPT2                ;Enter normal print option subroutine
1899 986D
1900 986D              @2       EQU   *
1901 986D A0 00                 LDY   #$00                     ;$00=user date fmt - $01=user time fmt
1902 986F 20 DF 93              JSR   PRTOPT                   ;Print option message
1903 9872
1904 9872 A0 00                 LDY   #$00                     ;$00=user date fmt - $01=user time fmt
1905 9874 20 FB 96              JSR   PRINTOPTDEF              ;Enter normal print option subroutine
1906 9877
1907 9877              @6       EQU   *
1908 9877 FA                    PLX                            ;Recall line number
1909 9878 DA                    PHX                            ;Resave 'X'
1910 9879 E0 05                 CPX   #CLOCKLN6-CLOCKLN1       ;If hour line then add AM/PM/'  '
1911 987B D0 0D                 BNE   @8                       ;
1912 987D A5 6D                 LDA   ZAMPMASCII               ;Print 1st character
1913 987F 20 D1 A9              JSR   COUTFF                   ;
1914 9882 A5 6E                 LDA   ZAMPMASCII+1             ;
1915 9884 20 D1 A9              JSR   COUTFF                   ;
1916 9887 20 91 AC              JSR   PR1BLNKFF                ;Print an extra space just in case
1917 988A
1918 988A              @8       EQU   *
1919 988A FA                    PLX                            ;Recall line number
1920 988B 68                    PLA                            ;Recall line message number currently on
1921 988C 1A                    INC   A                        ;Next message number
1922 988D E8                    INX                            ;Next line number
1923 988E E6 25                 INC   CV                       ;Next line
1924 9890 E4 04                 CPX   NUMLINES                 ;Are we done yet?
1925 9892 90 9C                 BCC   @111                     ;Loop til done
1926 9894 60                    RTS                            ;Back to caller
1927 9895
1928 9895
1929 9895
1930 9895
1931 9895                       TITLE 'Control Panel Misc Routines'
1932 9895
1933 9895              ******************************************************
1934 9895              *                                                    *
1935 9895              *   Misc Routines for Control Panel Desk Accessory   *
1936 9895              *                                                    *
1937 9895              *                    by                              *
1938 9895              *               Fern Bachman   $ 1985-1987           *
1939 9895              *               Joe Bo           1987-1989           *
1940 9895              *                                                    *
1941 9895              *       Copyright Apple Computer, Inc. 1985-1989     *
1942 9895              *                All Rights Reserved.                *
1943 9895              *                                                    *
1944 9895              ******************************************************
1945 9895
1946 9895
1947 9895              CLRTOBTM EQU   *                        ;Clear to bottom off screen
1948 9895 A5 22                 LDA   WNDTOP                   ;Save original value
1949 9897 48                    PHA                            ;
1950 9898 64 24                 STZ   CH                       ;Always clear from column 0
1951 989A 84 25                 STY   CV                       ;
1952 989C 84 22                 STY   WNDTOP                   ;Save as new top of window
1953 989E 20 E4 A9              JSR   VTABFF                   ;Move to start of clear area
1954 98A1 20 EE A9              JSR   HOMEFF                   ;Clear to end of screen
1955 98A4 68                    PLA                            ;Restore window top
1956 98A5 85 22                 STA   WNDTOP                   ;
1957 98A7 60                    RTS                            ;Back to caller
1958 98A8
1959 98A8
1960 98A8              GETSTATNUM EQU   *
1961 98A8 A6 00                 LDX   CURSCRN                  ;What screen we on?
1962 98AA BF 2D 83 FF           LDA   >STATTBL,X               ;
1963 98AE 85 1F                 STA   STATBYTE                 ;Save status byte for later testing
1964 98B0 29 0F                 AND   #$F                      ;Get number of lines/screen
1965 98B2 85 04                 STA   NUMLINES                 ; and save for later.
1966 98B4
1967 98B4 20 2B 9A              JSR   PRTAPTALK                ;CHK if printer port/appletalk
1968 98B7 F0 05                 BEQ   @03                      ;BRA if yes
1969 98B9              @02      EQU   *
1970 98B9 20 37 9A              JSR   MODAPTALK                ;CHK if modem port/appletalk
1971 98BC D0 0B                 BNE   @04                      ;BRA if AppleTalk not selected
1972 98BE              @03      EQU   *
1973 98BE 38                    SEC                            ;Set 'c' properly for sbc
1974 98BF A5 04                 LDA   NUMLINES                 ;Get the NUMLINES               
1975 98C1 E9 07                 SBC   #$07                     ;Get rid of the unwanted for ApTalk
1976 98C3 85 04                 STA   NUMLINES                 ;Store as new NUMLINES
1977 98C5 38                    SEC                            ;
1978 98C6 08                    PHP                            ;
1979 98C7 80 14                 BRA   @00
1980 98C9
1981 98C9              @04      EQU   *
1982 98C9 AF 8E 01 E1           LDA   >KEYUCVER                ;Get keyuc version#
1983 98CD C9 06                 CMP   #$06                     ;If >= $06, then Gyro or newer machine
1984 98CF 08                    PHP                            ;Save 'c'
1985 98D0 B0 0B                 BCS   @00                      ;BRA for Gyro or newer machine
1986 98D2
1987 98D2              @01      EQU   *
1988 98D2 E0 09                 CPX   #CPLN10-CPLN1            ;Is it mouse screen ? 
1989 98D4 D0 07                 BNE   @00                      ;BRA if not
1990 98D6 38                    SEC                            ;Set 'c' properly for sbc
1991 98D7 A5 04                 LDA   NUMLINES                 ;
1992 98D9 E9 05                 SBC   #$05                     ;Get 5 lines off, gs doesn't have
1993 98DB 85 04                 STA   NUMLINES                 ;
1994 98DD
1995 98DD              * Determine and setup line access table in zero page
1996 98DD
1997 98DD              @00      EQU   *
1998 98DD 8A                    TXA                            ;Which screen we looking at?
1999 98DE 0A                    ASL   A                        ;Shift for proper indexing
2000 98DF AA                    TAX                            ;
2001 98E0 BF 16 83 FF           LDA   >TRUELNTBL+1,X           ;Pick up information byte
2002 98E4 EB                    XBA                            ;Save in hi byte
2003 98E5 BF 15 83 FF           LDA   >TRUELNTBL,X             ;Pick up lo byte too
2004 98E9 28                    PLP                            ;Get back 'c'
2005 98EA B0 0E                 BCS   @22                      ;BRA for Gyro and newer machine
2006 98EC E0 08                 CPX   #$08                     ;Is it keyboard screen ?
2007 98EE D0 04                 BNE   @21                      ;Bra if not
2008 98F0 EB                    XBA                            ;Swap 'A'
2009 98F1 09 18                 ORA   #$18                     ;Mask off Disk2/Disk1 display lines
2010 98F3 EB                    XBA                            ;Save back to high byte
2011 98F4              @21      EQU   *
2012 98F4 E0 12                 CPX   #18                      ;Is it mouse screen ?
2013 98F6 D0 02                 BNE   @22                      ;Bra if not
2014 98F8 09 70                 ORA   #$70                     ;Mask off the unwanted keyboard mouse
2015 98FA
2016 98FA              @22      EQU   *
2017 98FA E0 0C                 CPX   #12                      ;Is it printer port screen?
2018 98FC D0 07                 BNE   @23                      ;
2019 98FE 48                    PHA                            ;Save off information in 'A'
2020 98FF AF C0 02 E1           LDA   >USERPORT1               ;Check for AppleTalk
2021 9903 80 09                 BRA   @24                      ;;
2022 9905              @23      EQU   *
2023 9905 E0 0E                 CPX   #14                      ;Is it modem screen ?
2024 9907 D0 13                 BNE   @20                      ;
2025 9909 48                    PHA                            ;
2026 990A AF CC 02 E1           LDA   >USERPORT2               ;
2027 990E              @24      EQU   *
2028 990E C9 02                 CMP   #$02
2029 9910 F0 03                 BEQ   @25
2030 9912 68                    PLA                            ;Pull back
2031 9913 80 07                 BRA   @20                      ;
2032 9915
2033 9915              @25      EQU   *
2034 9915 68                    PLA                            ;Get back information in 'A'
2035 9916 09 E0                 ORA   #$E0                     ;Mask off unwanted for AppleTalk
2036 9918 EB                    XBA                            ;Swap 'A'
2037 9919 09 FF                 ORA   #$FF                     ;Mask off some more
2038 991B EB                    XBA                            ;Swap back to proper position
2039 991C
2040 991C              @20      EQU   *
2041 991C A2 00                 LDX   #$00                     ;Start with 1st line
2042 991E              @11      EQU   *
2043 991E 20 3F 99              JSR   @18                      ;Do some stuff
2044 9921 E0 08                 CPX   #$08                     ;Stop at 'X'=8
2045 9923 90 F9                 BCC   @11                      ;Loop if not done
2046 9925
2047 9925 EB                    XBA                            ;Do same to hi byte
2048 9926              @12      EQU   *
2049 9926 20 3F 99              JSR   @18                      ;Do some stuff
2050 9929 E0 10                 CPX   #$10                     ;Stop at 'X'=16
2051 992B 90 F9                 BCC   @12                      ;Loop if not done
2052 992D
2053 992D A2 00                 LDX   #$00                     ;Go through REALLNTBL and make REALOPTTBL
2054 992F 9B                    TXY                            ;'Y' equal real offset counter
2055 9930              @14      EQU   *
2056 9930 B5 83                 LDA   REALLNTBL,X              ;
2057 9932 C9 80                 CMP   #$80                     ;'c'=1 then line is a delimiting line
2058 9934 94 93                 STY   REALOPTTBL,X             ;Save real offset in real line number tbl
2059 9936 E8                    INX                            ;Continue til 'X'=16
2060 9937 B0 01                 BCS   @15                      ;'c'=0 then not a delimiting line
2061 9939 C8                    INY                            ; so increment real offset counter.
2062 993A              @15      EQU   *
2063 993A E0 10                 CPX   #16                      ;'X'=16 then all done
2064 993C 90 F2                 BCC   @14                      ;Not done then loop back
2065 993E 60                    RTS                            ;Back to caller
2066 993F
2067 993F
2068 993F              @18      EQU   *
2069 993F 4A                    LSR   A                        ;Shift lo bit into 'c'
2070 9940 48                    PHA                            ;Save on stack for later
2071 9941 A0 80                 LDY   #$80                     ;Anticipate skip line
2072 9943 B0 01                 BCS   @19                      ;'c'=1 then line not OK to acgess
2073 9945 9B                    TXY                            ;Table gets index number
2074 9946              @19      EQU   *
2075 9946 94 83                 STY   REALLNTBL,X              ;Save in real line number table
2076 9948 68                    PLA                            ;Recall 'A' mask
2077 9949 E8                    INX                            ;Try next bit
2078 994A 60                    RTS                            ;
2079 994B
2080 994B
2081 994B              * SETUPLNSTUF sets up zero page pointers for PRINTLINE
2082 994B
2083 994B              SETUPLNSTUF EQU   *
2084 994B 8B                    PHB                            ;Save data bank register
2085 994C 4B                    PHK                            ;New data bank = program bank
2086 994D AB                    PLB                            ;
2087 994E A6 00                 LDX   CURSCRN                  ;What screen we on?
2088 9950
2089 9950 BD ED 82              LDA   OPTPTRTBL,X              ;Set up address of 1st message number
2090 9953 85 A4                 STA   OPTPTR+0                 ;Save in zero page
2091 9955
2092 9955 BD 01 83              LDA   CPDFPTRTBL,X             ;Address of defaults
2093 9958 85 AA                 STA   DEFAULTPTR+0             ;
2094 995A
2095 995A BD 0B 83              LDA   BRAMPTRTBL,X             ;Address of current user choices
2096 995D 85 AD                 STA   BRAMPTR+0                ;
2097 995F
2098 995F BD F7 82              LDA   NOPTPTRTBL,X             ;Set up address of num of options/line
2099 9962 85 A7                 STA   NOPTPTR+0                ;Save in zero page
2100 9964
2101 9964 A9 E1                 LDA   #^BRAMBUFFER             ;Bank number of current user choice tables
2102 9966 85 AF                 STA   BRAMPTR+2                ;
2103 9968 4B                    PHK                            ;Get data bank of tables
2104 9969 68                    PLA                            ;
2105 996A 85 A6                 STA   OPTPTR+2                 ;
2106 996C 85 AC                 STA   DEFAULTPTR+2             ;
2107 996E 85 A9                 STA   NOPTPTR+2                ;
2108 9970
2109 9970 A9 83                 LDA   #>DISPOP                 ;Hi byte of address for tables
2110 9972 85 A5                 STA   OPTPTR+1                 ;
2111 9974 85 AB                 STA   DEFAULTPTR+1             ;
2112 9976 85 A8                 STA   NOPTPTR+1                ;
2113 9978
2114 9978 A9 02                 LDA   #>USERCOLOR              ;Address of current user choices
2115 997A 85 AE                 STA   BRAMPTR+1                ;
2116 997C
2117 997C 8A                    TXA                            ;What screen we on?
2118 997D 0A                    ASL   A                        ;Shift to get correct index
2119 997E AA                    TAX                            ;Move to index
2120 997F AB                    PLB                            ;Restore data bank register
2121 9980 60                    RTS                            ;Back to caller
2122 9981
2123 9981
2124 9981              * GET1STLNNUM determines which screen is in use,
2125 9981              * calculates what message number the 1st line of
2126 9981              * the submenu screen should display, and saves
2127 9981              * that value at NUMFIRSTLN.
2128 9981
2129 9981              GET1STLNUM EQU   *
2130 9981 A6 00                 LDX   CURSCRN                  ;Which screen we on?
2131 9983 BF 39 83 FF           LDA   >LNNUMTBL,X              ;Recall message number of line
2132 9987 85 A3                 STA   NUMFIRSTLN               ;Save as number of first line
2133 9989 60                    RTS                            ;Back to caller
2134 998A
2135 998A
2136 998A              * GETUSROPT gets the user's option number from bank E1.
2137 998A              *
2138 998A              * On Input: 'X' = line number to look option up for
2139 998A              *
2140 998A              * On Output: 'A' contains the user's option number
2141 998A              *            Sets up NUMOPTS (maximum option number)
2142 998A              *                in zero page.
2143 998A
2144 998A              GETUSROPT0 EQU   *
2145 998A A6 01                 LDX   CURLINE                  ;Which line we on?
2146 998C              GETUSROPT EQU   *
2147 998C 86 01                 STX   CURLINE                  ;Line to access information for
2148 998E 20 4B 99              JSR   SETUPLNSTUF              ;
2149 9991 A6 01                 LDX   CURLINE                  ;Line to access information for
2150 9993 B4 93                 LDY   REALOPTTBL,X             ;Get real offset into tables
2151 9995 B7 A7                 LDA   [NOPTPTR],Y              ;Get max number of ottions for this line
2152 9997 10 56                 BPL   GETUSROPT6               ;+ then not a special one
2153 9999 48                    PHA                            ;Preserve 'A'
2154 999A A5 00                 LDA   CURSCRN                  ;Which screen we on?
2155 999C C9 03                 CMP   #CPLN4-CPLN1             ;
2156 999E F0 37                 BEQ   CLOCKLIM                 ;= then determine clock limits
2157 99A0 C9 04                 CMP   #CPLN5-CPLN1             ;
2158 99A2 F0 3D                 BEQ   LANGLIM                  ;= then determine language limits
2159 99A4
2160 99A4 5A                    PHY                            ;MUST preserve 'Y'
2161 99A5 A0 FF                 LDY   #$FF                     ;Counter for NUMOPTS
2162 99A7 C2 20                 REP   #$20                     ;Need 16 bit 'm'
2163 99A9 F4 00 00              PEA   $0000                    ;Set up subtraction value on stack
2164 99AC F4 00 80              PEA   $8000                    ;32768 is subtraction value
2165 99AF A5 58                 LDA   FREERAM                  ;Move to safe place
2166 99B1 85 1B                 STA   SHIFTER                  ;
2167 99B3 A5 5A                 LDA   FREERAM+2                ;
2168 99B5 85 1D                 STA   SHIFTER+2                ;
2169 99B7                       LONGA ON
2170 99B7 C9 80 00              CMP   #$0080                   ;If 8 megabytes limit it to 8 meg-64K
2171 99BA                       LONGA OFF
2172 99BA B0 11                 BCS   @2                       ;Maximum limit is 8128K not 8192K
2173 99BC C8                    INY                            ;'Y'=$00 to calculate limit normally
2174 99BD              @1       EQU   *                        ;Calculate max number of options
2175 99BD 38                    SEC                            ;Set 'c' to subtract
2176 99BE C8                    INY                            ;Increment for each subtract
2177 99BF A5 1B                 LDA   SHIFTER                  ;
2178 99C1 E3 01                 SBC   1,S                      ;Subtract 32768 each time
2179 99C3 85 1B                 STA   SHIFTER                  ;
2180 99C5 A5 1D                 LDA   SHIFTER+2                ;
2181 99C7 E3 03                 SBC   3,S                      ;
2182 99C9 85 1D                 STA   SHIFTER+2                ;
2183 99CB B0 F0                 BCS   @1                       ;Loop if still 'c'=1
2184 99CD
2185 99CD              @2       EQU   *
2186 99CD 84 05                 STY   NUMOPTS                  ;Save as number of options for wrapping
2187 99CF 68                    PLA                            ;Clean up stack
2188 99D0 68                    PLA                            ;
2189 99D1 E2 30                 SEP   #$30                     ;Back to monmtor mode
2190 99D3 7A                    PLY                            ;Restore 'Y'
2191 99D4 68                    PLA                            ;Clean up stack
2192 99D5 80 1A                 BRA   GETUSROPT8               ;Exit this way
2193 99D7
2194 99D7              CLOCKLIM EQU   *
2195 99D7 68                    PLA                            ;Clean up stack
2196 99D8 8B                    PHB                            ;Save data bank register
2197 99D9 4B                    PHK                            ;New data bank reg = program bank reg
2198 99DA AB                    PLB                            ;
2199 99DB B9 AF 83              LDA   NCLOCKOP,Y               ;Range for current option value
2200 99DE AB                    PLB                            ;Restore data bank register
2201 99DF 80 0E                 BRA   GETUSROPT6               ;Exit
2202 99E1
2203 99E1              LANGLIM  EQU   *
2204 99E1 68                    PLA                            ;Recall 'A'
2205 99E2 0A                    ASL   A                        ;Shift bit 7 to 'c' and bit 6 to bit 7
2206 99E3 30 06                 BMI   @1                       ;'+' then language limit requested
2207 99E5 AF FE 02 E1           LDA   >LANGS                   ;Pick up # of langs sent by key micro
2208 99E9 80 04                 BRA   GETUSROPT6               ;Exit
2209 99EB
2210 99EB              @1       EQU   *
2211 99EB AF 07 03 E1           LDA   >LAYOUTS                 ;Pick up # of layouts sent by key micro
2212 99EF
2213 99EF              GETUSROPT6 EQU   *
2214 99EF 85 05                 STA   NUMOPTS                  ;Save in zero page
2215 99F1
2216 99F1              GETUSROPT8 EQU   *
2217 99F1 B7 AD                 LDA   [BRAMPTR],Y              ;Get user's choice
2218 99F3 60                    RTS                            ;Back to caller
2219 99F4
2220 99F4
2221 99F4              * TSTTXTBGD test which line user is on, on the
2222 99F4              * Display screen.  If user is on 'Text' or 'Background'
2223 99F4              * and the colors match the 'c' flag is set to 1.
2224 99F4              * If the colors do not match the 'c' flag is set to 0.
2225 99F4
2226 99F4              TSTTXTBGD EQU   *
2227 99F4 48                    PHA                            ;Preserve 'A'
2228 99F5 97 AD                 STA   [BRAMPTR],Y              ;Save temporary new color value
2229 99F7 A6 01                 LDX   CURLINE                  ;Which line we on?
2230 99F9 E0 03                 CPX   #DISPLN4-DISPLN1         ;Line 4 is 'Text' line
2231 99FB F0 07                 BEQ   @2                       ;= then go do test
2232 99FD E0 04                 CPX   #DISPLN5-DISPLN1         ;Line 5 is 'Background' line
2233 99FF F0 03                 BEQ   @2                       ;= then go do test
2234 9A01
2235 9A01              @1       EQU   *                        ;Clear carry exit for no match
2236 9A01 68                    PLA                            ;Recall 'A'
2237 9A02 18                    CLC                            ;
2238 9A03 60                    RTS                            ;Back to caller
2239 9A04
2240 9A04              @2       EQU   *
2241 9A04 AF DA 02 E1           LDA   >USERTEXT                ;Which color is Text?
2242 9A08 CF DB 02 E1           CMP   >USERBACK                ;Does it = background color?
2243 9A0C D0 F3                 BNE   @1                       ;<>= then indicate no match and exit
2244 9A0E 68                    PLA                            ;Recall 'A'
2245 9A0F 38                    SEC                            ; else indicate a match and exit.
2246 9A10 60                    RTS                            ;Back to caller
2247 9A11
2248 9A11
2249 9A11              TURNONMTXT EQU   *                      ;Enable mouse text printing
2250 9A11 48                    PHA                            ;Preserve all registers
2251 9A12 DA                    PHX                            ;
2252 9A13 5A                    PHY                            ;
2253 9A14 20 84 FE              JSR   SETNORM                  ;Set output mask for normal characters
2254 9A17 A9 1B                 LDA   #MTXTON                  ;Enable mouse text character printing
2255 9A19              MTXTEXIT EQU   *
2256 9A19 20 D1 A9              JSR   COUTFF                   ;
2257 9A1C 7A                    PLY                            ;Restore registers
2258 9A1D FA                    PLX                            ;
2259 9A1E 68                    PLA                            ;
2260 9A1F 60                    RTS                            ;Back to caller
2261 9A20
2262 9A20
2263 9A20              TURNOFFMTXT EQU   *                     ;Disable mouse text printing
2264 9A20 48                    PHA                            ;Preserve all registers
2265 9A21 DA                    PHX                            ;
2266 9A22 5A                    PHY                            ;
2267 9A23 A9 7F                 LDA   #$7F                     ;Set output mask for inverse characters
2268 9A25 85 32                 STA   INVFLG                   ;Set inverse flag
2269 9A27 A9 18                 LDA   #MTXTOFF                 ;Disable mouse text character printing
2270 9A29 80 EE                 BRA   MTXTEXIT                 ;Exit this way
2271 9A2B
2272 9A2B              PRTAPTALK EQU   *                       ;CHK current screen is printer/aptalk
2273 9A2B A5 00                 LDA   CURSCRN                  ;CHK current screen
2274 9A2D C9 06                 CMP   #CPLN7-CPLN1             ;Is is printer port screen
2275 9A2F D0 12                 BNE   BOTHXIT                  ;BRA if no
2276 9A31 AF C0 02 E1           LDA   >USERPORT1               ;CHK for appletalk assigned
2277 9A35 80 0A                 BRA   TOCHKEND                 ;
2278 9A37
2279 9A37              MODAPTALK EQU   *                       ;CHK current screen is mod/appletalk
2280 9A37 A5 00                 LDA   CURSCRN                  ;CHK current screen
2281 9A39 C9 07                 CMP   #CPLN8-CPLN1             ;Is it modem port screen
2282 9A3B D0 06                 BNE   BOTHXIT                  ;BRA if no
2283 9A3D AF CC 02 E1           LDA   >USERPORT2               ;CHK appletalk assigned
2284 9A41              TOCHKEND EQU   *
2285 9A41 C9 02                 CMP   #$02                     ;
2286 9A43              BOTHXIT  EQU   *
2287 9A43 60                    RTS   
2288 9A44              PRTMODEM EQU   *                        ;CHK for 1st line of prt/modem screnn
2289 9A44 A5 01                 LDA   CURLINE
2290 9A46 D0 08                 BNE   @1
2291 9A48 A5 00                 LDA   CURSCRN                  ;
2292 9A4A C9 06                 CMP   #CPLN7-CPLN1             ;
2293 9A4C F0 02                 BEQ   @1
2294 9A4E C9 07                 CMP   #CPLN8-CPLN1             ;
2295 9A50              @1       EQU   *
2296 9A50 60                    RTS   
2297 9A51
2298 9A51
2299 9A51                       EJECT 
2300 9A51                       TITLE 'New BELL1 Routine'
2301 9A51
2302 9A51              ******************************************************
2303 9A51              *                                                    *
2304 9A51              *         New BELL1 Routine for 40/80 Columns        *
2305 9A51              *                                                    *
2306 9A51              *                         by                         *
2307 9A51              *                    Fern Bachman                    *
2308 9A51              *                    Mike Askins                     *
2309 9A51              *                    Joe  Bo
2310 9A51              *                                                    *
2311 9A51              *       Copyright Apple Computer, Inc. 1985-1989     *
2312 9A51              *                All Rights Reserved.                *
2313 9A51              *                                                    *
2314 9A51              ******************************************************
2315 9A51
2316 9A51
2317 9A51              NEWBELL1 EQU   *                        ;New BELL1 routine
2318 9A51 22 6C 00 E1           JSL   >BELLVECTOR              ;See if user supplied routine installed
2319 9A55 B0 01                 BCS   NEWBELL2                 ;If no routine installed then do this one
2320 9A57 60                    RTS                            ;Exit back to monitor
2321 9A58
2322 9A58              NEWBELL2 EQU   *
2323 9A58 08                    PHP                            ;Preserve interrupt status
2324 9A59 78                    SEI                            ;Make bell sound pretty with no ints
2325 9A5A A9 B0                 LDA   #$B0                     ;Delay in case repeated calls to BELL1
2326 9A5C 20 A8 FC              JSR   WAIT                     ;
2327 9A5F AD 36 C0              LDA   CYAREG                   ;Slow system down
2328 9A62 48                    PHA                            ;
2329 9A63 29 7F                 AND   #$7F                     ;
2330 9A65 8D 36 C0              STA   CYAREG                   ;
2331 9A68 DA                    PHX                            ;MUST preserve 'X' around this call
2332 9A69 8B                    PHB                            ;Save data bank register
2333 9A6A 20 82 F8              JSR   DBTOE1                   ;Data bank register to E1
2334 9A6D AD DF 02              LDA   |USERBELL                ;Get pitch for pattern
2335 9A70 49 0F                 EOR   #$0F                     ;Flip nybble
2336 9A72 8D 6D 01              STA   |PITCH                   ;
2337 9A75 9C 6E 01              STZ   |PITCH+1                 ;Be sure hi nybble = 0
2338 9A78 C2 20                 REP   #$20                     ;16 bit land for awhile
2339 9A7A                       LONGA ON
2340 9A7A A9 88 88              LDA   #TOGPATTERN              ;Now get pattern
2341 9A7D 8D 69 01              STA   |TOGGLEPAT               ;Save as toggle pattern
2342 9A80 A9 00 20              LDA   #DURBELL                 ;Set up bell duration counter
2343 9A83 8D 6B 01              STA   |DURATION                ;
2344 9A86                       LONGA OFF
2345 9A86 E2 30                 SEP   #$30                     ;Back to 8 bit land
2346 9A88 AD CA 00              LDA   |IRQ_VOLUME              ;True volume
2347 9A8B 8D 6F 01              STA   |VOLUME                  ;Save as temporary volume
2348 9A8E 48                    PHA                            ;Save original user volume
2349 9A8F
2350 9A8F 29 0F                 AND   #$0F                     ;Look at the volume
2351 9A91 D0 40                 BNE   @2                       ;Bell it if not =0                   
2352 9A93 AD 34 C0              LDA   |CLOCKCTL                ; Else save original border color
2353 9A96 29 0F                 AND   #$0F
2354 9A98 48                    PHA                            ;Temp store
2355 9A99 58                    CLI                            ;Enable interrupts
2356 9A9A
2357 9A9A 20 28 9B              JSR   WAITFORVBL               ;
2358 9A9D A9 0F                 LDA   #$0F                     ;Force white 
2359 9A9F 0C 34 C0              TSB   |CLOCKCTL
2360 9AA2 20 23 9B              JSR   MYWAIT                   ;Call wait routine
2361 9AA5
2362 9AA5 20 28 9B              JSR   WAITFORVBL
2363 9AA8 A9 0F                 LDA   #$0F                     ;Force black
2364 9AAA 1C 34 C0              TRB   |CLOCKCTL                ;
2365 9AAD 20 23 9B              JSR   MYWAIT                   ;
2366 9AB0
2367 9AB0 20 28 9B              JSR   WAITFORVBL               ;
2368 9AB3 A9 0F                 LDA   #$0F                     ;Force white 
2369 9AB5 0C 34 C0              TSB   |CLOCKCTL                ;
2370 9AB8 20 23 9B              JSR   MYWAIT                   ;
2371 9ABB
2372 9ABB 20 28 9B              JSR   WAITFORVBL               ;
2373 9ABE A9 0F                 LDA   #$0F                     ;Force black
2374 9AC0 1C 34 C0              TRB   |CLOCKCTL                ;
2375 9AC3 20 23 9B              JSR   MYWAIT                   ;
2376 9AC6
2377 9AC6
2378 9AC6 FA                    PLX                            ;Restore original border in x
2379 9AC7 78                    SEI                            ;Ints off
2380 9AC8 A9 0F                 LDA   #$0F                     ;Force black 
2381 9ACA 1C 34 C0              TRB   |CLOCKCTL
2382 9ACD 8A                    TXA   
2383 9ACE 0C 34 C0              TSB   |CLOCKCTL                ;Restore original border color
2384 9AD1 80 3D                 BRA   @8                       ;BRA to end border flashing
2385 9AD3
2386 9AD3              @2       EQU   *
2387 9AD3 18                    CLC                            ;Clear carry to start
2388 9AD4 C2 30                 REP   #$30                     ;16 bit land needed
2389 9AD6                       LONGA ON
2390 9AD6                       LONGI ON
2391 9AD6 AC 6D 01              LDY   |PITCH                   ;Pitch
2392 9AD9 A2 50 02              LDX   #DECAY                   ;Decay rate
2393 9ADC              @3       EQU   *
2394 9ADC 88                    DEY                            ;Decrement pitch counter
2395 9ADD D0 0B                 BNE   @4                       ;<>= then skip toggle
2396 9ADF AC 6D 01              LDY   |PITCH                   ;Reset pitch counter
2397 9AE2 2E 69 01              ROL   |TOGGLEPAT               ;Shift low byte by 1
2398 9AE5 90 03                 BCC   @4                       ;'c'=0/1 no toggle/toggle speaker
2399 9AE7 AD 30 C0              LDA   SPKR                     ;Toggle speaker
2400 9AEA              @4       EQU   *
2401 9AEA CA                    DEX                            ;Decrement decay counter
2402 9AEB D0 18                 BNE   @5                       ;
2403 9AED A2 50 02              LDX   #DECAY                   ;Reset decay counter
2404 9AF0 E2 20                 SEP   #$20                     ;Back to 8 bit mode to change volume
2405 9AF2 AD 6F 01              LDA   |VOLUME                  ;What's current volume?
2406 9AF5 F0 19                 BEQ   @8                       ;Volume = 0 then quit
2407 9AF7 3A                    DEC   A                        ;Decrement volume
2408 9AF8 8D 6F 01              STA   |VOLUME                  ;Resave volume counter
2409 9AFB 8D CA 00              STA   |IRQ_VOLUME              ;Save for interrupt handler
2410 9AFE 8D 3C C0              STA   |SOUNDCTL                ;Make hardware volume change
2411 9B01 C2 20                 REP   #$20                     ;Back to 16 bit land
2412 9B03 80 06                 BRA   @6                       ;Skip delay loop
2413 9B05
2414 9B05              @5       EQU   *
2415 9B05 A9 05 00              LDA   #0005                    ;28 cycle delay
2416 9B08              @5_5     EQU   *
2417 9B08 3A                    DEC   A                        ;
2418 9B09 D0 FD                 BNE   @5_5                     ;
2419 9B0B              @6       EQU   *
2420 9B0B CE 6B 01              DEC   |DURATION                ;Duration made it to 0 yet?
2421 9B0E D0 CC                 BNE   @3                       ;If not, then loop some more
2422 9B10
2423 9B10
2424 9B10              * Exit new bell routine after fixing up system volume
2425 9B10
2426 9B10              @8       EQU   *
2427 9B10 E2 30                 SEP   #$30                     ;Back to 8 bit land to quit
2428 9B12                       LONGA OFF
2429 9B12                       LONGI OFF
2430 9B12 68                    PLA                            ;Restore user volume
2431 9B13 8D CA 00              STA   |IRQ_VOLUME              ;
2432 9B16 8D 3C C0              STA   SOUNDCTL                 ;
2433 9B19 AB                    PLB                            ;Restore data bank register
2434 9B1A FA                    PLX                            ;Must preserve 'X' around this call
2435 9B1B A0 00                 LDY   #$00                     ;Some users require 'Y'=0 on exit
2436 9B1D 68                    PLA                            ;Restore CYAREG
2437 9B1E 8D 36 C0              STA   CYAREG                   ;
2438 9B21 28                    PLP                            ;Restore users interrupt status
2439 9B22 60                    RTS                            ;Back to caller
2440 9B23
2441 9B23
2442 9B23              MYWAIT   EQU   *
2443 9B23 A9 FF                 LDA   #$FF                     ;Input for 'wait'
2444 9B25 4C A8 FC              JMP   WAIT                     ;Do wait, appro 160 ms
2445 9B28
2446 9B28              * This small sub-routine would wait forever if a VBL task
2447 9B28              * kept me from reading the counters in time.  So we add 
2448 9B28              * a timeout counter.
2449 9B28              *
2450 9B28              * This counter assumes 18 cycles per loop
2451 9B28              * 2.8 million cycles per second
2452 9B28              * 60 vbls a second
2453 9B28              *
2454 9B28              * 2800000/60/18 = 2600 (approx)
2455 9B28              *
2456 9B28              * (Add 200 more for good luck)
2457 9B28              *
2458 9B28              WAITFORVBL EQU   *
2459 9B28 C2 10                 REP   #$10                     ;
2460 9B2A                       LONGA OFF
2461 9B2A                       LONGI ON
2462 9B2A              * 
2463 9B2A              * Don't want to use the vertical count here.  Better
2464 9B2A              *  to use the actual VBL signal.  (mensch/askins 3/16/89)
2465 9B2A              *
2466 9B2A AD 19 C0     @1       LDA   |RDVBLBAR
2467 9B2D 30 FB                 BMI   @1
2468 9B2F AD 19 C0     @2       LDA   |RDVBLBAR
2469 9B32 10 FB                 BPL   @2
2470 9B34              * 
2471 9B34              ; LDX #2800 ;No more than 2800 times through loop
2472 9B34              ;@WAIT EQU *
2473 9B34              ; LDA :VERTCNT ;Addr for read of video cntr bits v5-vb
2474 9B34              ; AND #$7F
2475 9B34              ; ASL A
2476 9B34              ; CMP #220
2477 9B34              ; BCS @DONE
2478 9B34              ; DEX
2479 9B34              ; BNE @WAIT
2480 9B34              *
2481 9B34              *
2482 9B34              @DONE    EQU   *
2483 9B34 E2 10                 SEP   #$10
2484 9B36                       LONGI OFF
2485 9B36 60                    RTS   
2486 9B37              BELLLEN  EQU   *-NEWBELL1               ;Length of NEWBELL1 routine
2487 9B37
2488 9B37
